/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.jar.Attributes;

import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.logging.LogDomains;

import com.sun.enterprise.server.ManagerFactory;
import com.sun.enterprise.server.ApplicationManager;
import com.sun.enterprise.server.StandAloneConnectorModulesManager;
import com.sun.enterprise.server.StandAloneEJBModulesManager;
import com.sun.enterprise.deployment.autodeploy.AutoDeployConstants;
import com.sun.enterprise.deployment.autodeploy.AutoDeployDirectoryScanner;

/**
 * SystemAppScanner takes the system directory and scans the archives based on
 * Application-Type specified in the manifest file of archive.
 * TargetFileFilter filters the archives based on the targetType and 
 * Application-Type
 * @author Sandhya E
 */

public class SystemAppScanner extends AutoDeployDirectoryScanner {

    private String targetType;
	
    public SystemAppScanner(String targetType){
        this.targetType = targetType;
    }
    
    protected File[] getListOfFiles(File dir, boolean includeSubDir) {
        return dir.listFiles(new TargetFileFilter(targetType));
    }
    
}

class TargetFileFilter implements  FileFilter{
    private static final Logger sLogger= LogDomains.getLogger(LogDomains.CORE_LOGGER);
    
    String targetType = null;
    
    TargetFileFilter(String targetType){
        this.targetType = targetType;    
    }
    
	 
    
    /** 
     * Accept method implementation of FileFilter, specific for app/modules,/br> 
     *its not a directory/br>
     *write/read permission is provided </br>
     *valid name </br>
     *valid type(ear/jar/war/rar etc) </br>
     *
     */        
    public boolean accept(File f){
        boolean flag=false;
        String name= f.getName();        
        String fileType = null;
        int lastIndex=-1;
        
        if(name !=null && name.length() >0){
            lastIndex = name.lastIndexOf('.');
            try{
                if (lastIndex >= 0) 
                    fileType = name.substring(lastIndex + 1);
                if(!f.isDirectory() && f.canRead())
				{
                    name=name.substring(0,lastIndex); //valid name                
                    if(name !=null && name.length() >0)
                       flag=true;
                }
            }catch(SecurityException se){
                sLogger.log(Level.WARNING, "SecurityException occured while accessing :" +f.getName());
                //ignore the file, and lets just not accept its as deployable component file 
            }catch(Exception e){
                sLogger.log(Level.WARNING, "Exception occured while accessing :" +f.getName());
                //ignore the file, and lets just not accept its as deployable component file 
            }
        }
        if(flag && isApplicableToTarget(f) && !(isRegistered(name,fileType))) {
            sLogger.log(Level.FINE,"Selecting file ["+ f.getAbsolutePath()+"] for autodeployment");
            return true;
        }else 
            return false;
        
    }

	private boolean isApplicableToTarget(File f) {
            JarFile j = null;
	    try{
		    j = new JarFile(f);
		    Manifest m = j.getManifest();
		    Attributes a = m.getMainAttributes();
		    String appType = a.getValue(Constants.APPLICATION_TYPE);
			if(appType == null) appType = Constants.USER;
			if(targetType.equals(Constants.TARGET_TYPE_ADMIN)){
			    if(appType.equals(Constants.SYSTEM_ADMIN) || appType.equals(Constants.SYSTEM_ALL))
				    return true;
				else
				    return false;
			}else if(targetType.equals(Constants.TARGET_TYPE_INSTANCE)){
			    if(appType.equals(Constants.SYSTEM_INSTANCE) || appType.equals(Constants.SYSTEM_ALL))
				    return true;
				else
				    return false;
			}
			return false;
		}catch(Exception e) {
		    sLogger.log(Level.WARNING, "Exception occured while accessing :" +f.getName());
			return false;
		} finally {
                    if (j != null) {
                        try {
                            j.close();
                        } catch (IOException ioe) {
                            sLogger.log(Level.WARNING, "Error closing jar file after checking for autodeploy", ioe);
                        }
                    }
                }
	}

        /**
         * Checks if an app is registered. Takes the registration
         * name and type of the archive
         * Type of the archive is ear/war/jar/rar
         * @return true if app is registered
         **/
        private boolean isRegistered(String name, String type)
        {
            try{
            
                if(type.equals(AutoDeployConstants.EAR_EXTENSION)) {
                
                    ApplicationManager amgr =
                                ManagerFactory.getApplicationManager();
                    return amgr.isRegistered(name);
                    
                }else if(type.equals(AutoDeployConstants.JAR_EXTENSION)) {
                
                    StandAloneEJBModulesManager emgr =
                                ManagerFactory.getSAEJBModulesManager();
                    return emgr.isRegistered(name);
                    
                }else if(type.equals(AutoDeployConstants.RAR_EXTENSION)) {
                
                    StandAloneConnectorModulesManager cmgr =
                                ManagerFactory.getSAConnectorModulesManager();
                    return cmgr.isRegistered(name);
                    
                }else if(type.equals(AutoDeployConstants.WAR_EXTENSION)) {
                }   
                
            }catch(Exception e){
                sLogger.log(Level.FINE, "error_occured_in_isreg",e);
            }   
            return false;
        }   

}
        
