/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server.logging;

import com.sun.logging.LogDomains;
import java.util.logging.ErrorManager;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Writes deployment audit records.
 * <p>
 * This class extends FileandSyslogHandler because it does nearly the same
 * function, except to a separate deployment audit file.
 */
public class DeploymentAuditLogHandler extends FileandSyslogHandler {
    
    private static final String CONFIGURED_LEVEL_PROPERTY_NAME = "com.sun.aas.deployment.audit.level";
    private static final String CONFIGURED_LEVEL_PROPERTY_DEFAULT = "OFF";
    
    private static final DeploymentAuditLogHandler thisInstance = 
        new DeploymentAuditLogHandler( );

    private String logFileName = "deployment.log"; 

    public static synchronized DeploymentAuditLogHandler getInstance( ) {
        return thisInstance;
    }

    /**
     * Creates a new instance of DeploymentAuditLogHandler, bypassing
     * logic in the superclass constructor that creates the AMXLoggingHook.
     */
    protected DeploymentAuditLogHandler() {
    }
    
    protected AMXLoggingHook createAMXLoggingHook() {
        return null;
    }

    protected String getLogFileName() {
        return logFileName;
    }
    
    /**
     *Returns the logging Level setting for the deployment auditing logger.
     *<p>
     *This method uses a system property rather than a normal logging level 
     *setting from domain.xml to avoid changing the domain.xml layout (due to schedule issues).
     *Later on this could be converted, time permitting.
     *@return the logging Level to be used for deployment logging; default if OFF
     */
    public static Level getConfiguredLevel() {
        Level result = Level.OFF;
        try {
            result = Level.parse(System.getProperty(CONFIGURED_LEVEL_PROPERTY_NAME, CONFIGURED_LEVEL_PROPERTY_DEFAULT));
        } catch (Throwable thr) {
            // Use the default OFF value but log the problem.
            Logger logger = LogDomains.getLogger(LogDomains.DPL_LOGGER);
            logger.log(Level.WARNING, thr.getLocalizedMessage(), thr);
        }
        return result;
    }
}
