
/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.server.logging;



import java.util.logging.SimpleFormatter;
import java.util.logging.LogRecord;

import java.text.MessageFormat;

import java.io.PrintWriter;
import java.io.StringWriter;


/**
 * Class ServerFormatter is a formatter designed for use by the ServerHandler
 * and designed for use by ereport (the web core native logging facility).
 * ereport is responsible for example for outputting the message header.
 */
public class ServerFormatter extends SimpleFormatter {

    private MessageFormat formatter;

    // Line separator string.  This is the value of the line.separator
    // property at the moment that the SimpleFormatter was created.
    // If we need to change the default line-seperator, it should be
    // done here.
    private static final String lineSeparator  =
        (String) java.security.AccessController
            .doPrivileged(new sun.security.action
                .GetPropertyAction("line.separator"));
    private static final String fieldSeparator = " ";

    /**
     * Method format
     *
     *
     * @param record
     *
     * @return
     */
    public synchronized String format(LogRecord record) {

        StringBuffer sb = new StringBuffer();

        // Get localized message after formatting per resource bundle if any.
        String message = formatMessage(record);

        sb.append(message);

        // Get stack trace if message was a result of exception.
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter  pw = new PrintWriter(sw);

                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(lineSeparator);
                sb.append(sw.toString());
            } catch (Exception ex) {}
        }
        sb.append(lineSeparator);

        return sb.toString();
    }
}

