/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server.ondemand;

import java.util.*;
import java.util.logging.*;
import com.sun.logging.LogDomains;
import com.sun.enterprise.server.*;
import com.sun.enterprise.server.ss.*;
import com.sun.enterprise.server.ondemand.entry.*;

import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.LifecycleEvent;
import com.sun.appserv.server.ServerLifecycleException;                                                                                                                             
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactoryImpl;
import com.sun.enterprise.server.pluggable.InternalServicesList;



/**
 * Represents on-demand server. This is the main class that ties ondemand logic
 * with rest of the application server.
 */
public class OnDemandServer extends ApplicationServer implements EntryPoint{

    private static boolean onDemandStartup = true;

    private static ServerEntryListener listener = null;
    private static SystemAppLoader systemAppLoader = null;
    private ServiceGroup sg = null;

   /** server logger */
    static Logger _logger = LogDomains.getLogger(LogDomains.CORE_LOGGER);


    /**
     * Server is initializing subsystems and setting up the runtime environment.
     * Prepare for the beginning of active use of the public methods of this
     * subsystem. This method is called before any of the public methods of 
     * this subsystem are utilized.  
     *
     * @param sc ServerContext the server runtime context.
     *
     * @exception IllegalStateException if this subsystem has already been
     *  started
     * @exception ServerLifecycleException if this subsystem detects a fatal 
     *  error that prevents this subsystem from being used
     */
    public void onInitialization(ServerContext context) 
                        throws ServerLifecycleException {
        listener = new ServerEntryListenerImpl(this);
        ServiceGroupBuilder builder = new ServiceGroupBuilder();
        sg = builder.buildServiceGroup(this);

        // Start the lazy startup framework.
        // This will open up network ports and block any incoming connections
        // till server startup completes.
        try {
            super.setServerContext(context);
            PluggableFeatureFactory pff = context.getPluggableFeatureFactory();
            ASLazyKernel lazyStartupKernel = pff.getASLazyKernel();
            onDemandStartup = lazyStartupKernel.startASSocketServices(context) ;
        } catch (Exception e) {
            onDemandStartup = false;
            // Quick startup is not enabled. Start with normal sequence.
        }
        //ORB is initialized lazily. If this variable is not set, 
        //Naming code somehow initializes ORB.
        com.sun.enterprise.naming.SerialInitContextFactory.
        setInitializeOrbManager(false);
        super.onInitialization(context);
        try {
            systemAppLoader = new SystemAppLoader();
        } catch (Exception e) {
            throw new ServerLifecycleException(e);
        }
    }

    /**
     * Server is starting up applications
     *
     * @param sc ServerContext the server runtime context.
     *
     * @exception ServerLifecycleException if this subsystem detects a fatal 
     *  error that prevents this subsystem from being used
     */
    public void onStartup() 
                        throws ServerLifecycleException {
        generateEntryContext(new Boolean(onDemandStartup));
        super.onStartup();
    }

    /**
     * Server is shutting down applications
     *
     * @exception ServerLifecycleException if this subsystem detects a fatal 
     *  error that prevents this subsystem from being used
     */
    public void onShutdown() 
                        throws ServerLifecycleException {
        super.onShutdown();
        try {
            sg.stop(null);
        } catch (Exception e) {
            throw new ServerLifecycleException(e);
        }
    }

    public void generateEntryContext(Object event) {
        ServerEntryHelper.generateStartUpEntryContext((Boolean) event);
    }

    protected ArrayList instantiateRuntimeServices() throws ServerLifecycleException {
        if (onDemandStartup) {
            InternalServicesList services = new TomcatServices();
            InternalServicesList ondemandservices = new OnDemandServices();
            String[][] servicesByName = services.getServicesByName();
            String[][] odsByName = ondemandservices.getServicesByName();
            if (servicesByName == null) {
               _logger.log(Level.SEVERE, "services.null");
               throw new ServerLifecycleException();
            }

            ArrayList serviceList = new ArrayList();

            // Instantiate service objects
            allServices :
            for (String[] service : servicesByName) {
               for (String[] ods : odsByName) {
                    if (service[0].equals(ods[0])) {
                        continue allServices;
                    }
               }
               try {
                   //String[] def = servicesByName[i];
                   Class c  = java.lang.Class.forName(service[1]);
                   Object o = c.newInstance();
                   serviceList.add(o);
               } catch (Exception ex) {
                   _logger.log(Level.SEVERE, "server.exception", ex);
                   throw new ServerLifecycleException(ex.getMessage());
               }
            }
            return serviceList;
        } else {
            return super.instantiateRuntimeServices();
        }
    }

    // Return the server entry listener.
    public static ServerEntryListener getServerEntryListener() {
        return listener;
    }

    // Return the system apploader.
    public static SystemAppLoader getSystemAppLoader() {
        return systemAppLoader;
    }

    // Return the main service group.
    public ServiceGroup getServiceGroup() {
        return sg;
    }

    public static boolean isOnDemandOff() {
        return onDemandStartup == false;
    }
    
}
