/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server.ondemand;

import java.util.*;
import java.util.logging.*;
import com.sun.logging.LogDomains;
import com.sun.enterprise.server.ondemand.entry.*;
import com.sun.enterprise.server.*;
import com.sun.enterprise.config.ConfigException;


/**
 * System apps are loaded by this class. ServiceGroups use this
 * class to load system apps that belong to them
 *
 * @author Binod PG
 * @see ServiceGroup
 */
public class SystemAppLoader {

    private Hashtable apps = new Hashtable();

    private ApplicationManager appsMgr  = ManagerFactory.getApplicationManager();
    private StandAloneEJBModulesManager ejbMgr = ManagerFactory.getSAEJBModulesManager();
    //private DummyWebModulesManager webMgr  = ManagerFactory.getSAWebModulesManager();

    static Logger _logger = LogDomains.getLogger(LogDomains.CORE_LOGGER);

    final Object [][] ejbSGApps = { 
                           {"MEjbApp", appsMgr}, 
                           {"__ejb_container_timer_app", appsMgr}
                         };
    // All web system apps, except webstart app,
    // are loaded by PEWebContainer, when it starts.
    // So, ondemand code does not need to worry about that.
    final Object[][] webSGApps = {
                          // {"adminapp",null}, 
                          // {"com_sun_web_ui", null}, 
                          // {"admingui", null},
                           {"__JWSappclients", appsMgr}
                         };
  
    /**
     * Constructs a datastructure that holds all system app info.
     */
    public SystemAppLoader() throws ConfigException {

        for (int i=0; i < ejbSGApps.length; i++) {
            apps.put(ejbSGApps[i][0], ejbSGApps[i][1]);
        }

        for (int i=0; i < webSGApps.length; i++) {
            apps.put(webSGApps[i][0], webSGApps[i][1]);
        }

    }

    public ArrayList getEjbServiceGroupSystemApps() {
        return createArrayList(ejbSGApps);
    }

    public ArrayList getWebServiceGroupSystemApps() {
        return createArrayList(webSGApps);
    }

    public ArrayList getResourcesServiceGroupSystemApps() {
        return null;
    }

    private ArrayList createArrayList(Object[][] objArray) {
        ArrayList list = new ArrayList();
        for (int i=0; i < objArray.length; i ++) {
            list.add(objArray[i][0]);
        }       
        return list;
    }

    public void loadSystemApps(ArrayList ids) {
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            Object appName = it.next();
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "About to load the system app: " + appName);
            }
            if (apps.containsKey(appName)) {
                AbstractManager mgr = (AbstractManager) apps.get(appName);           
                mgr.loadOneSystemApp((String) appName, true);
            }
        }
    }

}
