/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.server.pluggable;

import com.sun.enterprise.pluggable.PluggableFeatureFactoryBaseImpl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.sun.logging.LogDomains;

/**
 * An implementation of PluggableFeatureFactory interface using dynamic
 * proxies. This class does not directly implement the interface
 * PluggableFeatureFactory, but an proxy instance implementing the interface
 * can be obtained by a call to the static method getInstance(). In reality,
 * this class implements InvocationHnalder interface used to handle method
 * invocations on a dynamic proxy object.
 */
public class PluggableFeatureFactoryImpl extends PluggableFeatureFactoryBaseImpl {
    /**
     * Name of the property class containing feature name and feature
     * implementation class names.
     */
    private static final String DEFAULT_FEATURES_PROPERTY_CLASS =
            "com.sun.enterprise.server.pluggable.PEPluggableFeatureImpl";

    private static Logger _logger = LogDomains.getLogger(LogDomains.CORE_LOGGER);

    /**
     * Private constructor. The public instances of this object are not
     * available. The instance of this class is however used as invocation
     * handler for dynamic proxy returned by static method getInstance().
     */
    public PluggableFeatureFactoryImpl(Logger logger) {
        super(logger);
    }

    public static PluggableFeatureFactory getFactory() {
        String featurePropClass = System.getProperty(
                PluggableFeatureFactory.PLUGGABLE_FEATURES_PROPERTY_NAME,
                DEFAULT_FEATURES_PROPERTY_CLASS);
        _logger.log(Level.FINER, "featurePropClass: " + featurePropClass);
        PluggableFeatureFactoryImpl featureFactoryImpl = 
            new PluggableFeatureFactoryImpl(_logger);
        PluggableFeatureFactory featureFactory = (PluggableFeatureFactory)
            featureFactoryImpl.getInstance(featurePropClass);
        if (featureFactory == null) {	    
            _logger.log(Level.WARNING,
                    "j2eerunner.pluggable_feature_noinit", featurePropClass);
        }
        return featureFactory;
    }

    protected String getDefaultFeatureFactoryPropertyName() {
        return System.getProperty(
            PluggableFeatureFactory.PLUGGABLE_FEATURES_PROPERTY_NAME);
    }

    protected Object createFeatureFactory(InvocationHandler handler) {
        return Proxy.newProxyInstance(
                PluggableFeatureFactory.class.getClassLoader(),
                new Class[] { PluggableFeatureFactory.class },
                handler);
    }
}
