/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.transaction;

import java.rmi.RemoteException;
import java.io.Serializable;
import javax.transaction.*;
import java.util.ArrayList;

public class TransactionAdminBean implements java.io.Serializable {
	private Object m_identifier;
        private String m_id;
	private String m_status;
	private long m_elapsedTime;
        private String m_componentName;
        private ArrayList<String> m_resourceNames;

	public TransactionAdminBean(Object identifier, String id, String status, long elapsedTime,
                                    String componentName, ArrayList<String> resourceNames) {
		m_identifier = identifier;
                m_id=id;
		m_status = status;
		m_elapsedTime = elapsedTime;
                m_componentName = componentName;
                m_resourceNames = resourceNames;
	}

	// getter functions ...

	public Object getIdentifier(){
		return m_identifier;
	}

        public String getId(){
            return m_id;
        }

	public String getStatus(){
		return m_status;
	}

	public long getElapsedTime(){
		return m_elapsedTime;
	}

        public String getComponentName() {
            return m_componentName;
        }

        public ArrayList<String> getResourceNames() {
            return m_resourceNames;
        }

	// setter functions ...

	public void setIdentifier(Object id){
		m_identifier = id;
        }

        public void setId(String id){
            m_id=id;
        }

	public void setStatus(String sts){
		m_status = sts;
	}

	public void setElapsedTime(long time){
		m_elapsedTime = time;
	}

        public void setComponentName(String componentName) {
            m_componentName = componentName;
        }

        public void setResourceNames(ArrayList<String> resourceNames) {
            m_resourceNames = resourceNames;
        }
     
}



