/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.transaction;

import javax.sql.*;
import javax.transaction.xa.*;
import javax.security.auth.Subject;
import javax.resource.spi.ManagedConnection;

import com.sun.enterprise.util.i18n.StringManager;

/**
 * Wrappers over XAResources extend from this class. This class simply implements the
 * the standard XAResource interface. In addition it holds the XAConnection which is
 * set by XARecoveryManager and is used by deriving classes to implement workarounds.
 * An example of class extending from this is OracleXARescource.
 *
 * @author <a href="mailto:bala.dutt@sun.com">Bala Dutt</a>
 * @version 1.0
 */
public abstract class XAResourceWrapper implements XAResource
{

	/// Sting Manager for Localization
    private static StringManager sm = StringManager.getManager(XAResourceWrapper.class);

    protected ManagedConnection m_xacon;
    protected Subject subject;
    public void init(ManagedConnection xacon,Subject subject){
        m_xacon=xacon;
        this.subject = subject;
    }
    public void end(Xid xid, int i) throws XAException{
        throw new XAException(sm.getString("transaction.for_recovery_only"));
    }
    public void forget(Xid xid) throws XAException{
        throw new XAException(sm.getString("transaction.for_recovery_only"));
    }
    public int getTransactionTimeout() throws XAException{
        throw new XAException(sm.getString("transaction.for_recovery_only"));
    }
    public boolean isSameRM(XAResource xaresource) throws XAException
    {
        throw new XAException(sm.getString("transaction.for_recovery_only"));
    }
    public int prepare(Xid xid) throws XAException{
        throw new XAException(sm.getString("transaction.for_recovery_only"));
    }
    public boolean setTransactionTimeout(int i) throws XAException {
        throw new XAException(sm.getString("transaction.for_recovery_only"));
    }
    public void start(Xid xid, int i) throws XAException{
        throw new XAException(sm.getString("transaction.for_recovery_only"));
    }

    public abstract Xid[] recover(int flag) throws XAException;

    public abstract void commit(Xid xid, boolean flag) throws XAException;

    public abstract void rollback(Xid xid) throws XAException;

	/**
    public Xid[] recover(int flag) throws XAException {
        throw new XAException("This is to be implemented by sub classes");
    }
    public void commit(Xid xid, boolean flag) throws XAException{
        throw new XAException("This is to be implemented by sub classes");
    }
    public void rollback(Xid xid) throws XAException{
        throw new XAException("This is to be implemented by sub classes");
    }
	*/
}
