/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.web.deploy;


import org.apache.catalina.deploy.MessageDestination;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;


/**
 * Decorator of class <code>org.apache.catalina.deploy.MessageDestination</code>
 *
 * @author Jean-Francois Arcand
 */

public class MessageDestinationDecorator extends MessageDestination {

    private MessageDestinationDescriptor decoree;
    
    public MessageDestinationDecorator(MessageDestinationDescriptor decoree){
        this.decoree = decoree;
    }
    // ------------------------------------------------------------- Properties


    /**
     * The description of this destination.
     */
    private String description = null;

    public String getDescription() {
        return decoree.getDescription();
    }

 
    public String getDisplayName() {
        return decoree.getDisplayName();
    }

  
    public String getLargeIcon() {
        return decoree.getLargeIconUri();
    }

  
    public String getName() {
        return decoree.getName();
    }

    public String getSmallIcon() {
        return decoree.getSmallIconUri();
    }


}
