/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.webservice;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.webservice.spi.ServiceDelegateCreationListener;
import com.sun.enterprise.webservice.spi.ServiceDelegateImpl;

/**
 * This class will be notified of all ServiceDelegation creation which happens
 * when a new Service instance is created. 
 *
 * @author Jerome Dochez
 */
public class ServiceCreationListenerImpl implements ServiceDelegateCreationListener {
    
    /** Creates a new instance of ServiceCreationListenerImpl */
    public ServiceCreationListenerImpl() {
    }
    
    /**
     * this is stateless object, we really need only once instance at this time
     * to register the port/dispatch creation listener.
     */
    private static ServiceCreationListenerImpl instance;
    protected static void initInstance() {
        instance = new ServiceCreationListenerImpl();        
    }
    
    /** 
     * @return the current ServiceDelegateCreationListener 
     */
    public static ServiceDelegateCreationListener getDefaultListener() {
        if (instance==null) {
            synchronized(ServiceDelegateCreationListener.class) {
                if (instance==null) {
                        initInstance();
                }
            }
        }
        return instance;
    }
    
    /*
     * This is the callback that a new service has been created. This can
     * happen when the application server creates a port managed instance
     * but also when the user code does a "new Service()". We need to 
     * distinguish both use case
     */
    public void serviceCreated(ServiceDelegateImpl delegate) {
        // do the mtom thing...
        ServiceReferenceDescriptor ref = delegate.getServiceReference();
        if (ref==null) {
            // nothing we can do, the user probably did a new Service()
            return;
        }
        // I am going to register a new PortCreationListener for this puppy
        InvInterfaceCreationListenerImpl portListener = new InvInterfaceCreationListenerImpl(ref);
        delegate.addListener(portListener);        
    }
}
