/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web.connector.grizzly;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

import org.apache.coyote.Response;
import org.apache.coyote.http11.InternalOutputBuffer;



/**
 * Output buffer.
 * Buffer the bytes until the <code>ByteChunk</code> is full or the request
 * is completed.
 * 
 * @author Jean-Francois Arcand
 * @author Scott Oaks
 */
public class SocketChannelOutputBuffer extends InternalOutputBuffer{

    // ----------------------------------------------------------- Constructors
    

    /**
     * Alternate constructor.
     */
    public SocketChannelOutputBuffer(Response response, int headerBufferSize) {

        super(response,headerBufferSize);

        socketBuffer.allocate(headerBufferSize, headerBufferSize);
        useSocketBuffer = true;        
    }


    // -------------------------------------------------------------- Variables

    /**
     * Underlying output socketChannel.
     */
    protected SocketChannel socketChannel;
    
    // ------------------------------------------------------------- Properties


    /**
     * Set the underlying socket output stream.
     */
    public void setChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }


    /**
     * Get the underlying socket output stream.
     */
    public SocketChannel getChannel() {
        return socketChannel;
    }

    
    // --------------------------------------------------------- Public Methods

    /**
     * Send an acknoledgement without buffering.
     */
    public void sendAck() throws IOException {

        if (!committed)
            flushChannel(ByteBuffer.wrap(Constants.ACK_BYTES));

    }

    
    /**
     * Callback to write data from the buffer.
     */
    public void realWriteBytes(byte cbuf[], int off, int len)
        throws IOException {
        if (len > 0) {
            flushChannel(ByteBuffer.wrap(cbuf,off,len));
        }
    }
    
    
    /**
     * Flush the buffer by looping until the <code>ByteBuffer</code> is empty
     * @param bb the ByteBuffer to write.
     */   
    public void flushChannel(ByteBuffer bb) throws IOException{
        OutputWriter.flushChannel(socketChannel, bb);
    }
}
