/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */ 

package org.apache.taglibs.standard.examples.taglib;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.LoopTag;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * <p>Tag handler for &lt;odd&gt;
 *
 * @author Pierre Delisle
 * @version $Revision: 1.2 $ $Date: 2005/12/08 01:20:40 $
 */
public class EvenTag extends TagSupport {
    
    //*********************************************************************
    // TagSupport methods
    
    public int doStartTag() throws JspException {
        LoopTag iteratorTag = (LoopTag)findAncestorWithClass(
        this, LoopTag.class);
        if (iteratorTag == null) {
            throw new JspTagException("<even> must be nested within a LoopTag");
        }
        
        int count = iteratorTag.getLoopStatus().getCount();
        return (count % 2 == 0) ? EVAL_BODY_INCLUDE : SKIP_BODY;
    }
}
