/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */ 

package org.apache.taglibs.standard.examples.util;

import java.io.PrintWriter;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;

/**
 * ServletResponseWrapper used for the the generation of 
 * semi-dynamic pages.
 * <p>
 * This 'wrapped' response object is passed as the second argument 
 * to the internal RequestDispatcher.include(). It channels
 * all output text into the PrintWriter specified in the
 * constructor (which is associated with the file where the
 * output of the JSP page has to be saved).
 *
 * @author Pierre Delisle
 * @version $Revision: 1.2 $ $Date: 2005/12/08 01:20:42 $
 */
public class ServletResponseWrapperForWriter
    extends HttpServletResponseWrapper
{
    /**
     * The writer that will get all the output of the response.
     */
    PrintWriter writer;

    public ServletResponseWrapperForWriter(ServletResponse response, 
					   PrintWriter writer) 
    {
	super((HttpServletResponse)response);
	this.writer = writer;
    }

    /**
     * Returns the Writer associated with the response.
     */
    public java.io.PrintWriter getWriter()
	throws java.io.IOException 
    {
	return writer;
    }
}

