#
# The contents of this file are subject to the terms 
# of the Common Development and Distribution License 
# (the License).  You may not use this file except in
# compliance with the License.
# 
# You can obtain a copy of the license at 
# https://glassfish.dev.java.net/public/CDDLv1.0.html or
# glassfish/bootstrap/legal/CDDLv1.0.txt.
# See the License for the specific language governing 
# permissions and limitations under the License.
# 
# When distributing Covered Code, include this CDDL 
# Header Notice in each file and include the License file 
# at glassfish/bootstrap/legal/CDDLv1.0.txt.  
# If applicable, add the following below the CDDL Header, 
# with the fields enclosed by brackets [] replaced by
# you own identifying information: 
# "Portions Copyrighted [year] [name of copyright owner]"
# 
# Copyright 2006 Sun Microsystems, Inc. All rights reserved.
#

#
# NOTE: This file is used by Enterprise, Messaging AND Collabra servers.
#       Please do NOT change indiscriminately
#

include $(BUILD_ROOT)/make/defines_UNIX.mk
LOCAL_COPY=0

PERL_DIR        =/usr
PERL5         	=$(PERL_DIR)/bin/perl
PERL		=$(PERL5)
CC		=$(PRE_CC) /usr/bin/g++
C               =$(PRE_C)  /usr/bin/gcc
C++C		=$(CC)
AR              =/usr/bin/ar
TAR             =/bin/tar
RANLIB          =/usr/bin/ranlib
LD		=$(PRE_LD) /usr/bin/g++
ZIP		=/usr/bin/zip
UNZIP		=/usr/bin/unzip
GZIP		=/bin/gzip
GUNZIP		=/bin/gunzip
SHELL		=/bin/sh
DATE		=/bin/date
MKDIR		=/bin/mkdir
TOUCH		=/bin/touch
CHMOD		=/bin/chmod
CP		=/bin/cp
MV		=/bin/mv
ECHO		=/bin/echo
SED		=/bin/sed
MKDIR		=/bin/mkdir
LN		=/bin/ln -f
NMAKE		=/usr/bin/make -f
STRIP		=/usr/bin/strip -x
RM		=/bin/rm

# we don't have that stuff
NO_SEARCH=1
NO_WAI=1

ifdef DEBUG_BUILD
# optimize to catch more warnings
#CC_DEBUG	= -g2 -Wall -O1
#C_DEBUG         = -g2 -Wall -O1
# easy on the warnings for now
CC_DEBUG	= -g
C_DEBUG         = -g
LD_DEBUG	=
else 
# optimized settings here
CC_DEBUG	= -W -O2
C_DEBUG         = -W -O2
LD_DEBUG	= 
endif

LD_DYNAMIC	= -bundle -arch i386 -arch ppc -isysroot /Developer/SDKs/MacOSX10.4u.sdk
RPATH_PREFIX	= -Wl,
RPATH_ORIGIN=.
RPATH_ORIGIN_SLASH=
LD_RPATHS=

PLATFORM_DEF	= -DDarwin -DDARWIN -D__GLIBC_MAJOR=2 -D__GLIBC_MINOR=3 -D_REENTRANT

# -verbose for printing all informational messags
# -w0 for stricter than ANSI-C prototype warnings
# -fPIC is needed for any code that ends up in a shared library
PLATFORM_CC_OPTS = -fPIC -arch i386 -arch ppc -isysroot /Developer/SDKs/MacOSX10.4u.sdk
PLATFORM_C_OPTS  = -fPIC -arch i386 -arch ppc -isysroot /Developer/SDKs/MacOSX10.4u.sdk
PLATFORM_LD_OPTS =

# These libraries are platform-specific, not system-specific
# WARNING no -pthread option on Mac
PLATFORM_LIB	  = 


ifndef JAVA_VERSION
JAVA_VERSION	= 4
endif

JNI_MD_LIBTYPE  = client
JNI_MD_NAME	= Darwin
JNI_MD_SYSNAME	= powerpc

# force native threads to be used at build runtime
export THREADS_FLAG=native

# No support for mapfiles
USE_MAPFILE=

# on Mac OS X, jni libraries have a jnilib extension
DYNAMIC_LIB_SUFFIX=jnilib


