/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier;

import java.io.ByteArrayInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

import com.sun.enterprise.logging.LogDomains;
import tools.com.sun.enterprise.util.XMLValidationHandler;

public class NameToken {

    final static String XMLtop =
            "<!DOCTYPE NameToken [ <!ELEMENT NameToken EMPTY> <!ATTLIST NameToken value NMTOKEN #REQUIRED>]> <NameToken value=\""; // NOI18N


    final static String XMLbottom = "\"/>"; // NOI18N

    // Logger to log messages
    private static Logger logger = LogDomains.getLogger(
            LogDomains.AVK_VERIFIER_LOGGER);

    /**
     * Determine is value is legal NMToken type
     *
     * @param value xml element to be checked
     * @return <code>boolean</code> true if xml element is legal NMToken,
     *         false otherwise
     */
    public static boolean isNMTOKEN(String value) {
/*
        com.sun.enterprise.util.LocalStringManagerImpl smh =
            StringManagerHelper.getLocalStringsManager();
*/
        String XMLdoc = XMLtop + value + XMLbottom;
        logger.log(Level.FINE,
                "com.sun.enterprise.tools.verifier.NameToken.print", // NOI18N
                new Object[]{XMLdoc});

        try {
            InputSource source = new InputSource(
                    new ByteArrayInputStream(XMLdoc.getBytes()));
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setValidating(true);
            // ValidatingParser p = new ValidatingParser();
            XMLReader p = spf.newSAXParser().getXMLReader();
//            XMLErrorHandler eh = new XMLErrorHandler(null);
            p.setErrorHandler(new XMLValidationHandler());
            p.parse(source);
            return true;

        } catch (Exception e) {
            return false;
        } 
    }
}


