/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ClassFileLoader.java
 *
 * Created on August 13, 2004, 9:05 PM
 */

package com.sun.enterprise.tools.verifier.apiscan.classfile;

import java.io.IOException;

/**
 * This is loader for ClassFile similar to what ClassLoader is for class in
 * Java.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public interface ClassFileLoader {
    /**
     * @param externalClassName class name in external form. This is same as
     *                          what is used in java.lang.ClassLoader.load() or
     *                          Class.forName(). It is upto the implementation
     *                          to decide if they want to use caching or not.
     * @return The {@link ClassFile} loaded.
     * @throws IOException if specified class could not be found.
     * @see ClassFile
     */
    ClassFile load(String externalClassName) throws IOException;
}
