/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.verifier.BaseVerifier;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.FrameworkContext;

/**
 * @author Vikas Awasthi
 */
public class ApplicationVerifier extends BaseVerifier {

    private Application application = null;

    public ApplicationVerifier(FrameworkContext frameworkContext,
                               Application application) {
        this.frameworkContext = frameworkContext;
        this.application = application;
    }

    /**
     * Responsible for running application based verifier tests on the the web archive.
     * Called from runVerifier in {@link BaseVerifier} class.
     *
     * @throws Exception
     */
    public void verify() throws Exception {
        if (areTestsNotRequired(frameworkContext.isApp()) &&
                areTestsNotRequired(frameworkContext.isPersistenceUnits()))
            return;
        preVerification();
        if(frameworkContext.isPortabilityMode())
            application.setClassLoader(context.getClassLoader());
        CheckMgr checkMgrImpl = new AppCheckMgrImpl(frameworkContext);
        verify(application, checkMgrImpl);
    }

    public Descriptor getDescriptor() {
        return application;
    }

    protected ClassLoader createClassLoader() {
        return application.getClassLoader();
    }

    /**
     * @return String archive base
     */
    protected String getArchiveUri() {
        return frameworkContext.getJarFileName();
    }

    protected String[] getDDString() {
        String dd[] = {"META-INF/sun-application.xml", // NOI18N
                       "META-INF/application.xml"}; // NOI18N
        return dd;
    }

    protected String getClassPath() {
        return null;
    }
}
