/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.gui;

import javax.swing.*;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;

public class MainFrame extends JFrame {


    /**
     * Deploytool gui entry point (acessed via reflection)
     */
    private static MainFrame verifierPanel = null;
    private static boolean exitOnClose = false;
    MainPanel mp = null;

    /**
     * Constructor.
     */
    public MainFrame() {
        this(null);
    }

    public MainFrame(String jarFileName) {
        this(jarFileName, false, null);
    }

    public MainFrame(String jarFileName, boolean exitOnClose,
                     Verifier verifier) {
        super((StringManagerHelper.getLocalStringsManager().getLocalString
                ("com.sun.enterprise.tools.verifier.gui.MainFrame" + // NOI18N
                ".WindowTitle", // NOI18N
                        "Verify Specification Compliance"))); // NOI18N
        setExitOnClose(exitOnClose);

        // 508 compliance for the JFrame
        this.getAccessibleContext().setAccessibleName(StringManagerHelper.getLocalStringsManager()
                .getLocalString("com.sun.enterprise.tools.verifier.gui.MainFrame" + // NOI18N
                ".jfName", // NOI18N
                        "Main Window")); // NOI18N
        this.getAccessibleContext().setAccessibleDescription(StringManagerHelper.getLocalStringsManager()
                .getLocalString("com.sun.enterprise.tools.verifier.gui.MainFrame" + // NOI18N
                ".jfDesc", // NOI18N
                        "This is the main window of the verifier tool")); // NOI18N

        if (exitOnClose) {
            this.addWindowListener(new WindowAdapter() {
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
        }
        Container contentPane = getContentPane();
        mp = new MainPanel(this, jarFileName, verifier);
        contentPane.add(mp);
        JOptionPane.showMessageDialog(this,
                StringManagerHelper.getLocalStringsManager()
                .getLocalString("com.sun.enterprise.tools.verifier.gui.Deprecation", // NOI18N
                        "\nThis GUI has been deprecated. Please use the GUI that comes with NetBeans."), // NOI18N
                "WARNING", JOptionPane.WARNING_MESSAGE); // NOI18N
    }

    public static JFrame getDeploytoolVerifierFrame(File jarFile) {
        StringManagerHelper.setLocalStringsManager(Verifier.class);
        if (verifierPanel == null) {
            verifierPanel = new MainFrame();
        } else {
            verifierPanel.getMainPanel().reset();
        }
        if (jarFile != null) {
            verifierPanel.getMainPanel().setJarFilename(
                    jarFile.getAbsolutePath());
        }
        return verifierPanel;
    }


    public MainPanel getMainPanel() {
        return mp;
    }

    public static boolean getExitOnClose() {
        return exitOnClose;
    }

    public static void setExitOnClose(boolean b) {
        exitOnClose = b;
    }
}
