/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import java.io.*;
import java.util.jar.*;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;

import com.sun.enterprise.deployment.deploy.shared.FileArchive;

/** 
 * The alt-dd element specifies a URI to the post-assembly deployment descriptor
 * relative to the root of the application 
 */

public class AppAltDDWeb extends ApplicationTest implements AppCheck { 


    /** 
     * The alt-dd element specifies a URI to the post-assembly deployment descriptor
     * relative to the root of the application 
     *
     * @param descriptor the Application deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(Application descriptor) {

	Result result = getInitializedResult();

 
	if (descriptor.getWebBundleDescriptors().size() > 0) {
	    boolean oneFailed = false;
            int na = 0;
	    for (Iterator itr = descriptor.getWebBundleDescriptors().iterator(); itr.hasNext();) {
		WebBundleDescriptor wbd = (WebBundleDescriptor) itr.next();

		if (wbd.getModuleDescriptor().getAlternateDescriptor()!=null) {
		    if (!(wbd.getModuleDescriptor().getAlternateDescriptor().equals(""))) {
                        InputStream deploymentEntry=null;
//                        File f = null;
//                        if (Verifier.getEarFile() != null)
//                            f = new File(Verifier.getEarFile());
                        
			try {
//                            if (f==null){
                                String uri = getAbstractArchiveUri(descriptor);
//                                try {
                                    FileArchive arch = new FileArchive();
                                    arch.open(uri);
                                    deploymentEntry = arch.getEntry(wbd.getModuleDescriptor().getAlternateDescriptor());
//                                }catch (Exception e) { }
//                            }else{
//
//                                jarFile = new JarFile(f);
//                                ZipEntry deploymentEntry1 = jarFile.getEntry(wbd.getModuleDescriptor().getAlternateDescriptor());
//                                if (deploymentEntry1 != null)
//                                    deploymentEntry = jarFile.getInputStream(deploymentEntry1);
//                            }

			    if (deploymentEntry != null) {
				result.addGoodDetails(smh.getLocalString
						      (getClass().getName() + ".passed",
						       "Found alternate web deployment descriptor URI file [ {0} ] within [ {1} ]",
						       new Object[] {wbd.getModuleDescriptor().getAlternateDescriptor(),wbd.getName()}));
			    } else { 
                                if (!oneFailed) {
                                    oneFailed = true;
                                }
				result.addErrorDetails(smh.getLocalString
						       (getClass().getName() + ".failed",
							"Error: No alternate web deployment descriptor URI file found, looking for [{0} ] within [ {1} ]",
							new Object[] {wbd.getModuleDescriptor().getAlternateDescriptor(), wbd.getName()}));
			    }
			    //jarFile.close();
        
			} catch (FileNotFoundException ex) {
			    Verifier.debug(ex);
                            if (!oneFailed) {
                                oneFailed = true;
                            }
			    
		result.failed(smh.getLocalString
					  (getClass().getName() + ".failedException",
					   "Error: File not found trying to read deployment descriptor file [ {0} ] within [ {1} ]",
					   new Object[] {wbd.getModuleDescriptor().getAlternateDescriptor(), wbd.getName()}));
			} catch (IOException ex) {
			    Verifier.debug(ex);
                            if (!oneFailed) {
                                oneFailed = true;
                            }
			    
		result.failed(smh.getLocalString
					  (getClass().getName() + ".failedException1",
					   " Error: IO Error trying to read deployment descriptor file [ {0} ] within [ {1} ]",
					   new Object[] {wbd.getModuleDescriptor().getAlternateDescriptor(), wbd.getName()}));
	                } finally {
                            try {
                                if (deploymentEntry != null)
                                    deploymentEntry.close();
                            } catch (Exception x) {}
                        }

		    }
		} else {
                    na++;
		    result.notApplicable(smh.getLocalString
					 (getClass().getName() + ".notApplicable1",
					  "There is no java web alternative deployment descriptor in [ {0} ]",
					  new Object[] {wbd.getName()}));
		}
	    }
            if (oneFailed) {
                result.setStatus(Result.FAILED);
            } else if (na == descriptor.getWebBundleDescriptors().size()) {
                result.setStatus(Result.NOT_APPLICABLE);
            } else {
                result.setStatus(Result.PASSED);
            }

	} else {
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "There are no web components in application [ {0} ]",
				  new Object[] {descriptor.getName()}));
	}

 
	return result;
    }
}
