/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import java.util.Iterator;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;

/**
 * The connector element specifies the URI of a connector
 * module, relative to the top level of the application package.
 *
 */

public class ConnectorURI extends ApplicationTest implements AppCheck {
    
    /**
     * The connector element specifies the URI of a connector
     * module, relative to the top level of the application package.
     *
     * @param descriptor the Application deployment descriptor
     *
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(Application descriptor) {
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        Result result = getInitializedResult();
        
        for (Iterator itr = descriptor.getRarDescriptors().iterator(); itr.hasNext();) {
            ConnectorDescriptor cond = (ConnectorDescriptor) itr.next();
            
            if (!cond.getModuleDescriptor().getArchiveUri().endsWith(".rar")) {
                addErrorDetails(result, compName);
                result.failed
                        (smh.getLocalString
                        (getClass().getName() + ".failed",
                        "Error: [ {0} ] does not specify the URI [ {1} ] of a Connector module, relative to the top level of the application package [ {2} ], or does not end with \".rar\"",
                        new Object[] {cond.getName(), cond.getModuleDescriptor().getArchiveUri(), descriptor.getName()}));
            }
        }
        if(result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed
                    (smh.getLocalString
                    (getClass().getName() + ".passed",
                    "All the Connector URIs are valid."));
        }
        
        return result;
    }
}
