/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.util.io.FileUtils;
import java.io.*; 
import java.util.jar.*;
import java.util.*;

/**     
 * Application's listed J2EE modules exist in the Enterprise archive
 * The J2EE module element contains an ejb, java, or web element, which indicates 
 */
public class ModulesExistAppClient extends ApplicationTest implements AppCheck { 


    /**     
     * Application's listed J2EE modules exist in the Enterprise archive
     * The J2EE module element contains an ejb, java, or web element, which indicates 
     * the module type and contains a path to the module file
     *
     * @param descriptor the Application deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(Application descriptor) {

	Result result = getInitializedResult();

  
         
	if (descriptor.getApplicationClientDescriptors().size() > 0) {
	    boolean oneFailed = false;
	    for (Iterator itr = descriptor.getApplicationClientDescriptors().iterator(); itr.hasNext();) {
		ApplicationClientDescriptor acd = (ApplicationClientDescriptor) itr.next();

		if (!(acd.getModuleDescriptor().getArchiveUri().equals(""))) {
		    JarFile jarFile = null;
                    InputStream deploymentEntry=null;
                    boolean moduleDirExists = false;

//		    try {
//                        File applicationJarFile = null;
//                        if (Verifier.getEarFile() != null) {
//                           applicationJarFile = new File(Verifier.getEarFile());
//                        }

//                        if (applicationJarFile == null) {
//                            try {
                              String archBase = 
                                 getAbstractArchiveUri(descriptor);
                              String moduleName =
			         acd.getModuleDescriptor().getArchiveUri();
                              String moduleDir = FileUtils.makeFriendlyFileName(moduleName);
                              File f = new File(archBase + File.separator 
                                           + moduleDir);
                              moduleDirExists = f.isDirectory();
//                            }catch (Exception e) { throw new IOException(e.getMessage());}
//                        }
//                        else {
//			  jarFile = new JarFile(applicationJarFile);
//			  ZipEntry deploymentEntry1 = jarFile.getEntry(
//                             acd.getModuleDescriptor().getArchiveUri());
//                          deploymentEntry = jarFile.getInputStream(
//                                             deploymentEntry1);
//                        }
        
			if ((deploymentEntry != null) || (moduleDirExists)) {
			    result.addGoodDetails(smh.getLocalString
					  (getClass().getName() + ".passed",
					   "J2EE Application Client module [ {0} ] exists within [ {1} ].",
					   new Object[] {acd.getModuleDescriptor().getArchiveUri(), descriptor.getName()}));
			} else {
                            if (!oneFailed) {
                                oneFailed = true;
                            }
			    result.addErrorDetails(smh.getLocalString
					  (getClass().getName() + ".failed",
					   "Error: J2EE Application Client module [ {0} ] does not exist within [ {1} ].",
					   new Object[] {acd.getModuleDescriptor().getArchiveUri(), descriptor.getName()}));
			}
        
//		    } catch (FileNotFoundException ex) {
//            finally {
                        try {
                          if (jarFile != null)
                              jarFile.close();
                          if (deploymentEntry != null)
                              deploymentEntry.close();
                        } catch (Exception x) {}
//                    }

		}

	    }
            if (oneFailed) {
                result.setStatus(Result.FAILED);
            } else {
                result.setStatus(Result.PASSED);
            }
	} else {
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "There are no java application clients in application [ {0} ]",
				  new Object[] {descriptor.getName()}));
	}
	return result;
    }
}
