/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
/*
 * CheckResourceAdapterClass.java
 *
 * Created on August 29, 2002
 */

package com.sun.enterprise.tools.verifier.tests.connector;

import java.io.File;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.tests.*;
import java.util.Iterator;
import java.util.Set;

/**
 * Test that "resourceadapter-class" implements 
 * "javax.resource.spi.ResourceAdapter".
 *
 * @author Anisha Malhotra 
 * @version 
 */
public class CheckResourceAdapterClass
extends ConnectorTest 
implements ConnectorCheck 
{

  /** <p>
   * Test that "resourceadapter-class" implements 
   * "javax.resource.spi.ResourceAdapter".
   * </p>
   *
   * @param descriptor deployment descriptor for the rar file
   * @return result object containing the result of the individual test
   * performed
   */
  public Result check(ConnectorDescriptor descriptor) {

    Result result = getInitializedResult();
    ComponentNameConstructor compName = 
      getVerifierContext().getComponentNameConstructor();
    String resourceAdapterClass = descriptor.getResourceAdapterClass();
    if(resourceAdapterClass.equals(""))
    {
      if(descriptor.getInBoundDefined())
      {
        // resourceadapter-class cannot be null
        result.addErrorDetails(smh.getLocalString
            ("tests.componentNameConstructor",
             "For [ {0} ]",
             new Object[] {compName.toString()}));
        result.failed(smh.getLocalString
            (getClass().getName() + ".failed1",
             "resourceadapter-class cannot be empty if the resource" + 
             " adapter provides inbound communication"));
      }
      else
      {
          result.addNaDetails(smh.getLocalString
              ("tests.componentNameConstructor",
               "For [ {0} ]",
               new Object[] {compName.toString()}));
          result.notApplicable(smh.getLocalString
              ("com.sun.enterprise.tools.verifier.tests.connector.resourceadapter.notApp",
               "resourceadapter-class is not specified."));
      }
      return result;
    }
    Context context = getVerifierContext();
    ClassLoader jcl = context.getRarClassLoader();
    Class implClass = null;
    try
    {
      implClass = Class.forName(resourceAdapterClass, false, getVerifierContext().getClassLoader());    
    }
    catch(ClassNotFoundException e)
    {
      result.addErrorDetails(smh.getLocalString
          ("tests.componentNameConstructor",
           "For [ {0} ]",
           new Object[] {compName.toString()}));
      result.failed(smh.getLocalString
          ("com.sun.enterprise.tools.verifier.tests.connector." + 
          "CheckResourceAdapter.nonexist",
           "Error: The class [ {0} ] as defined under resourceadapter-class " +            "in the deployment descriptor does not exist",
           new Object[] {resourceAdapterClass}));
      return result;
    }
    if(!isImplementorOf(implClass, "javax.resource.spi.ResourceAdapter"))
    {
      result.addErrorDetails(smh.getLocalString
          ("tests.componentNameConstructor",
           "For [ {0} ]",
           new Object[] {compName.toString()}));
      result.failed(smh.getLocalString(getClass().getName() + ".failed",
            "Error: resourceadapter-class [ {0} ] does not implement javax.resource.spi.ResourceAdapter",
            new Object[] {resourceAdapterClass}));
    }
    else
    {
      result.addGoodDetails(smh.getLocalString
          ("tests.componentNameConstructor",
           "For [ {0} ]",
           new Object[] {compName.toString()}));	
      result.passed(smh.getLocalString(getClass().getName() + ".passed",
            "Success: resourceadapter-class implements javax.resource.spi.ResourceAdapter"));                     
    }
    return result;                
  }
}
