/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
/*
 * ConnectionFactoryGetConnection.java
 *
 * Created on October 3, 2000, 5:41 PM
 */

package com.sun.enterprise.tools.verifier.tests.connector.cci;

import java.lang.reflect.Method;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.tests.*;

/**
 * Check that the getConnection method of the client API Connection factory
 * is implemented accordingly to the spec
 * @author  Jerome Dochez
 * @version 
 */
public class ConnectionFactoryGetConnection 
extends ConnectionFactoryTest 
implements ConnectorCheck 
{

  /**
   * <p>
   * all connector tests should implement this method. it run an individual
   * test against the resource adapter deployment descriptor. 
   * </p>
   *
   * @paramm descriptor deployment descriptor for the rar file
   * @return result object containing the result of the individual test
   * performed
   */    
  public Result check(ConnectorDescriptor descriptor) {

    Result result = getInitializedResult();
    ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
    if(isCCIImplemented(descriptor, result))
    {
      Class cf = testConnectionFactoryImpl(descriptor, result);
      if (cf == null) 
        return result;
      String className = cf.getName();

      do {
        Method[] allMethods = cf.getMethods();
        for (int i=0;i<allMethods.length;i++) {
          if (allMethods[i].getName().equals("getConnection")) {
            // found it, check the return type
            String connection = getConnectionInterface(descriptor, result);
            if (isSubclassOf(allMethods[i].getReturnType(), connection)) {
              result.addGoodDetails(smh.getLocalString
                  ("tests.componentNameConstructor",
                   "For [ {0} ]",
                   new Object[] {compName.toString()}));
              result.passed(smh.getLocalString(
                    getClass().getName() + ".passed",
                    "The getConnection method of the [ {0} ] returns the [ {1} ] interface",
                    new Object[] {cf.getName(), connection} ));        
            } else {
              result.addErrorDetails(smh.getLocalString
                  ("tests.componentNameConstructor",
                   "For [ {0} ]",
                   new Object[] {compName.toString()}));
              result.failed(smh.getLocalString(                        
                    getClass().getName() + ".failed",
                    "Error: The getConnection method of the [ {0} ] does not return the [ {1} ] interface",
                    new Object[] {cf.getName(), connection} ));        
            }
            return result;
          } 
        }
        cf = cf.getSuperclass();
      } while (cf!=null);
      result.addWarningDetails(smh.getLocalString
          ("tests.componentNameConstructor",
           "For [ {0} ]",
           new Object[] {compName.toString()}));
      result.warning(smh.getLocalString(
            getClass().getName() + ".warning",
            "Warning: The getConnection method is not defined by [ {0} ]",
            new Object[] {className} ));
    }
    else
    {
      result.addNaDetails(smh.getLocalString
          ("tests.componentNameConstructor",
           "For [ {0} ]",
           new Object[] {compName.toString()}));
      result.notApplicable(smh.getLocalString
          ("com.sun.enterprise.tools.verifier.tests.connector.cci.notApp",
           "The CCI interfaces do not seem to be implemented by this resource adapter"));
    }
    return result;
  }
}
