/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the "License").  You may not use this file except 
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt or 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html. 
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * HEADER in each file and include the License file at 
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable, 
 * add the following below this CDDL HEADER, with the 
 * fields enclosed by brackets "[]" replaced with your 
 * own identifying information: Portions Copyright [yyyy] 
 * [name of copyright owner]
 */
package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.tools.verifier.tests.InjectionTargetTest;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.InjectionCapable;

import java.util.List;

/**
 * The field or method where injection annotation is used may have any access 
 * qualifier (public , private , etc.) but must not be static or final.
 * 
 * @author Vikas Awasthi
 */
public class EJBInjectionAnnotationModifiers extends InjectionTargetTest {
    
    protected List<InjectionCapable> getInjectables(String className) {
        EjbDescriptor descriptor = (EjbDescriptor) getDescriptor();
        return descriptor.getInjectableResourcesByClass(getClassName());
    }

    protected String getClassName() {
        EjbDescriptor descriptor = (EjbDescriptor) getDescriptor();
        return descriptor.getEjbClassName();
    }
}
