/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.elements;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

/** 
 * The resource-ref element res-auth subelement must be "Application" or
 * "Container".
 */
public class EjbResAuthElement extends EjbTest implements EjbCheck { 



    /**
     * The resource-ref element res-auth subelement must be "Application" or
     * "Container".
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	boolean oneFailed = false;
	if (!descriptor.getResourceReferenceDescriptors().isEmpty()) {
	    for (Iterator itr = descriptor.getResourceReferenceDescriptors().iterator(); itr.hasNext();) {
		ResourceReferenceDescriptor nextResourceReference = (ResourceReferenceDescriptor) itr.next();
		// The resource-ref element res-auth subelement must be "Application" or
		// "Container".
		if ((nextResourceReference.getAuthorization().equals(ResourceReferenceDescriptor.APPLICATION_AUTHORIZATION)) ||
		    (nextResourceReference.getAuthorization().equals(ResourceReferenceDescriptor.CONTAINER_AUTHORIZATION))) {
		    result.addGoodDetails(smh.getLocalString
					  ("tests.componentNameConstructor",
					   "For [ {0} ]",
					   new Object[] {compName.toString()}));
		    result.addGoodDetails
			(smh.getLocalString
			 (getClass().getName() + ".passed",
			  "Resource-ref element res-auth sub-element value [ {0} ] is valid within bean [ {1} ]",
			  new Object[] {nextResourceReference.getAuthorization(),descriptor.getName()}));
		} else {
		    oneFailed = true;
		    result.addErrorDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));
		    result.addErrorDetails
			(smh.getLocalString
			 (getClass().getName() + ".failed",
			  "Error: Resource-ref element res-auth sub-element value [ {0} ] is not valid within bean [ {1} ]",
			  new Object[] {nextResourceReference.getAuthorization(),descriptor.getName()}));
		} 
	    }
	    if (!oneFailed){
		result.setStatus(Result.PASSED);
	    } else {
		result.setStatus(Result.FAILED);
	    }
	} else {
	    result.addNaDetails(smh.getLocalString
				("tests.componentNameConstructor",
				 "For [ {0} ]",
				 new Object[] {compName.toString()}));
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "There are no resource reference elements defined within this bean [ {0} ]",
				  new Object[] {descriptor.getName()}));
	}


	return result;

    }
}
