/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.elements;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

/** 
 * Security role used in method permission element must be defined in the roles
 * element of the deployment descriptor.
 */
public class MethodPermissionSecurityRoleExists extends EjbTest implements EjbCheck { 



    /** 
     * Security role used in method permission element must be defined in the 
     * roles element of the deployment descriptor.
     * 
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        Map permissionedMethods = descriptor.getPermissionedMethodsByPermission();
        boolean oneFailed = false;
        if (permissionedMethods.size() >0) {
	    for (Iterator e = permissionedMethods.keySet().iterator(); e.hasNext();) {            
                MethodPermission nextPermission = (MethodPermission) e.next();
                if (nextPermission.isRoleBased()) {
                    if (!descriptor.getEjbBundleDescriptor().getRoles().contains(nextPermission.getRole())) {
		        oneFailed =true;
			result.addErrorDetails(smh.getLocalString
					       ("tests.componentNameConstructor",
						"For [ {0} ]",
						new Object[] {compName.toString()}));
		        result.addErrorDetails
			    (smh.getLocalString
			    (getClass().getName() + ".failed",
			    "Error: Method permissions role [ {0} ] must be one of the roles defined in bean [ {1} ]",
			    new Object[] {nextPermission.getRole().getName(), descriptor.getName()}));
		    } else {
			result.addGoodDetails(smh.getLocalString
					      ("tests.componentNameConstructor",
					       "For [ {0} ]",
					       new Object[] {compName.toString()}));
		        result.addGoodDetails
			    (smh.getLocalString
			    (getClass().getName() + ".passed",
			    "Valid: Method permissions role [ {0} ] is defined as one of the roles defined in bean [ {1} ]",
			    new Object[] {nextPermission.getRole().getName(), descriptor.getName()}));
		    } 
                } else {
                    addNaDetails(result, compName);
                    result.notApplicable(smh.getLocalString
                             (getClass().getName() + ".notApplicable1",
                              "There are no role based method-permissions within this bean [ {0} ]",
                              new Object[] {descriptor.getName()}));
                }
	    } 
	    if (oneFailed) {
    	        result.setStatus(Result.FAILED);
    	    } else {
            if(result.getStatus() != Result.NOT_APPLICABLE)
	            result.setStatus(Result.PASSED);
    	    } 
	} else {
	    result.addNaDetails(smh.getLocalString
				("tests.componentNameConstructor",
				 "For [ {0} ]",
				 new Object[] {compName.toString()}));
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "There are no <method-permission> elements within this bean [ {0} ]",
				  new Object[] {descriptor.getName()}));
	} 
	return result;
    }
}

