/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2;

import java.util.*;
import java.lang.reflect.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.*;

/**
 * Select methods must be associated with an EJB QL query which includes a 
 * SELECT clause
 *
 * @author  Jerome Dochez
 * @version 
 */
public class SelectMethodQL extends SelectMethodTest {

    /**
     * <p>
     * run an individual test against a declared ejbSelect method
     * </p>
     * 
     * @param m is the ejbSelect method
     * @param descriptor is the entity declaring the ejbSelect
     * @param result is where to put the result
     * 
     * @return true if the test passes
     */
    protected boolean runIndividualSelectTest(Method m, EjbCMPEntityDescriptor descriptor, Result result) {
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        // We don't use getQueryFor to free ourselfves from classloader issues.
        Set set = descriptor.getPersistenceDescriptor().getQueriedMethods();
        Iterator iterator = set.iterator();
        while(iterator.hasNext()) {
            MethodDescriptor queryMethod = (MethodDescriptor) iterator.next();
            if (queryMethod.getName().equals(m.getName())) {
                Class mParms[] = m.getParameterTypes();
	
                String queryParms[] = queryMethod.getParameterClassNames();
	
		if (queryParms != null) {
	
                if (queryParms.length == mParms.length) {
                    boolean same = true;
                    for (int i=0;i<mParms.length;i++) {
                        if (!mParms[i].getName().equals(queryParms[i]))
                            same=false;                    
                    }
                    if (same) {
                        QueryDescriptor qd = descriptor.getPersistenceDescriptor().getQueryFor(queryMethod);
                        String query = qd.getQuery();
                        if (query == null && qd.getSQL()==null) {
			    result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
                            result.addErrorDetails(smh.getLocalString
                                ("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.SelectMethodQL.failed2",
                                "Error : [ {0} ] EJB-QL query and description are null",
		                new Object[] {m.getName()}));                                                    
                            return false;
                        } else {
                            if (query==null) {
				result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
                                result.addGoodDetails(smh.getLocalString
            		            ("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.SelectMethodQL.passed1",
                                    "Description for [ {0} ] is provided",
        		            new Object[] {m.getName()}));                                                       
                                return true;
                            }                                
                            if (query.toUpperCase().indexOf("SELECT")==-1) {
				result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
                                result.addErrorDetails(smh.getLocalString
                                    ("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.SelectMethodQL.failed2",
                                    "Error : EJB-QL query for method [ {0}  is null",
		                    new Object[] {m.getName()}));                                                    
                                return false;
                            } else {
				result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
                                result.addGoodDetails(smh.getLocalString
            		            ("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.SelectMethodQL.passed2",
                                    "EJB-QL query for [ {0} ] is correct",
        		            new Object[] {m.getName()}));                                                       
                                return true;
                            }
                        }                        
                    }
                }
		}
		else if (mParms.length == 0) {
	
		    result.addGoodDetails(smh.getLocalString
					  ("tests.componentNameConstructor",
					   "For [ {0} ]",
					   new Object[] {compName.toString()}));
		    result.addGoodDetails(smh.getLocalString
					  ("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.SelectMethodQL.passed3",
					   "No EJB-QL query found",
					   new Object[] {}));                                                       
		    return true;
		} else {
		    result.addErrorDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));
		    result.addErrorDetails(smh.getLocalString
					   ("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.SelectMethodQL.failed2",
					    "Error : EJB-QL query for method [ {0}  is null",
					    new Object[] {m.getName()}));                                                    
		    return false;
		}
            }	    	    
        }
	
	result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
        result.addErrorDetails(smh.getLocalString
	    ("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.SelectMethodQL.failed1",
            "Error : [ {0} ] does not have a XML query element associated",
	    new Object[] {m.getName()}));                                                    
        return false;            
    }
}
