/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.ejbfindbyprimarykey;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.*;
import java.lang.ClassLoader;
import java.lang.reflect.Method;

import com.sun.enterprise.tools.verifier.tests.*;

/**
 * Define ejbFindByPrimaryKey method name test.
 *
 *     Every entity enterprise Bean class must define the ejbFindByPrimaryKey
 *     method. The return type for this method must be the primary key type.
 *     (i.e. the ejbFindByPrimaryKey method must be a single-object finder).
 *
 */
public class EjbFindByPrimaryKeyName extends EjbTest implements EjbCheck {


    /**
     * Define ejbFindByPrimaryKey method name test.
     *
     *     Every entity enterprise Bean class must define the ejbFindByPrimaryKey
     *     method. The return type for this method must be the primary key type.
     *     (i.e. the ejbFindByPrimaryKey method must be a single-object finder).
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	if (descriptor instanceof EjbEntityDescriptor) {
	    String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
    	boolean ejbFindByPrimaryKeyMethodFound = false;
		boolean oneFailed = false;
		try {
		    // retrieve the EJB Class Methods
		    Context context = getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
		    Class EJBClass = Class.forName(descriptor.getEjbClassName(), false, getVerifierContext().getClassLoader());
            // start do while loop here....
            do {
                Method [] ejbFinderMethods = EJBClass.getDeclaredMethods();
                for (int j = 0; j < ejbFinderMethods.length; ++j) {
                    if (ejbFinderMethods[j].getName().equals("ejbFindByPrimaryKey")) {
                        // Every entity enterprise Bean class must define the
                        // ejbFindByPrimaryKey method. The result type for this method must
                        // be the primary key type (i.e. the ejbFindByPrimaryKey method
                        // must be a single-object finder).
                        ejbFindByPrimaryKeyMethodFound = true;
                        result.addGoodDetails(smh.getLocalString
                                ("tests.componentNameConstructor",
                                        "For [ {0} ]",
                                        new Object[] {compName.toString()}));
                        result.addGoodDetails(smh.getLocalString
                                (getClass().getName() + ".debug1",
                                        "For EJB Class [ {0} ] Finder Method [ {1} ]",
                                        new Object[] {EJBClass.getName(),ejbFinderMethods[j].getName()}));
                        result.addGoodDetails(smh.getLocalString
                                (getClass().getName() + ".passed",
                                        "An [ {0} ] method was found.",
                                        new Object[] {ejbFinderMethods[j].getName()}));
                        break;
                    }
                }
            } while (((EJBClass = EJBClass.getSuperclass()) != null) && (!ejbFindByPrimaryKeyMethodFound));
            if (EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistence)&&ejbFindByPrimaryKeyMethodFound) {
                result.setStatus(result.PASSED);
                return result;
            } else {
                if(EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistence) && !ejbFindByPrimaryKeyMethodFound) {
                    oneFailed = true;
                    result.addErrorDetails(smh.getLocalString
                            ("tests.componentNameConstructor",
                                    "For [ {0} ]",
                                    new Object[] {compName.toString()}));
                    result.addErrorDetails(smh.getLocalString
                            (getClass().getName() + ".debug3",
                                    "For EJB Class [ {0} ]",
                                    new Object[] {descriptor.getEjbClassName()}));
                    result.addErrorDetails(smh.getLocalString
                            (getClass().getName() + ".failed",
                                    "Error: No ejbFindByPrimaryKey method was found in bean class."));
                } else if(EjbEntityDescriptor.CONTAINER_PERSISTENCE.equals(persistence) && ejbFindByPrimaryKeyMethodFound) {
                    oneFailed = true;
                    result.addErrorDetails(smh.getLocalString
                            ("tests.componentNameConstructor",
                                    "For [ {0} ]",
                                    new Object[] {compName.toString()}));
                    result.addErrorDetails(smh.getLocalString
                            (getClass().getName() + ".debug3",
                                    "For EJB Class [ {0} ]",
                                    new Object[] {descriptor.getEjbClassName()}));
                    result.addErrorDetails(smh.getLocalString
                            (getClass().getName() + ".failed1",
                                    "Error:  ejbFindByPrimaryKey method was found for CMP bean class."));
                } else {//(CONTAINER_PERSISTENCE.equals(persistence))
                    result.addNaDetails(smh.getLocalString
                            ("tests.componentNameConstructor",
                                    "For [ {0} ]",
                                    new Object[] {compName.toString()}));
                    result.notApplicable(smh.getLocalString
                            (getClass().getName() + ".notApplicable2",
                                    "Expected persistence type [ {0} ], but bean [ {1} ] has persistence type [ {2} ]",
                                    new Object[] {EjbEntityDescriptor.BEAN_PERSISTENCE,descriptor.getName(),persistence}));
                    return result;
                }
            }
        } catch (ClassNotFoundException e) {
            Verifier.debug(e);
            result.addErrorDetails(smh.getLocalString
                    ("tests.componentNameConstructor",
                            "For [ {0} ]",
                            new Object[] {compName.toString()}));
            result.failed(smh.getLocalString
                    (getClass().getName() + ".failedException",
                            "Error: EJB Class [ {0} ] does not exist or is not loadable.",
                            new Object[] {descriptor.getEjbClassName()}));
            oneFailed = true;
        }
        if (oneFailed) {
            result.setStatus(result.FAILED);
        } else {
            result.setStatus(result.PASSED);
        }
        return result;
    } else {
        result.addNaDetails(smh.getLocalString
                ("tests.componentNameConstructor",
                        "For [ {0} ]",
                        new Object[] {compName.toString()}));
        result.notApplicable(smh.getLocalString
                (getClass().getName() + ".notApplicable",
                        "[ {0} ] expected {1} bean, but called with {2} bean.",
                        new Object[] {getClass(),"Entity","Session"}));
        return result;
    }
    }
}
