/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.pksinglefield;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Field;
import java.util.*;
import java.lang.ClassLoader;
import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;

/** 
 * The type of the primkey-field must be the same as the primary key type.
 */
public class PrimekeyFieldPrimaryKeyType extends EjbTest implements EjbCheck { 


    /** 
     * The type of the primkey-field must be the same as the primary key type.
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	// The type of the primkey-field must be the same as the primary key type.
	if (descriptor instanceof EjbEntityDescriptor) {
	    String persistence =
		((EjbEntityDescriptor)descriptor).getPersistenceType();

	    if (EjbEntityDescriptor.CONTAINER_PERSISTENCE.equals(persistence)) {
		try {
		    Context context = getVerifierContext();
		ClassLoader jcl = context.getClassLoader();
		    Class c = Class.forName(descriptor.getEjbClassName(), false, getVerifierContext().getClassLoader());
		    try {
			if (((EjbCMPEntityDescriptor)descriptor).getPrimaryKeyFieldDesc() != null) {
			    Field pkf = c.getDeclaredField(((EjbCMPEntityDescriptor)descriptor).getPrimaryKeyFieldDesc().getName());
			    Class pkfType = pkf.getType();
			    try {
				String primkey =
				    ((EjbEntityDescriptor)descriptor).getPrimaryKeyClassName();
    
				boolean foundMatch = false;
				if (primkey.equals(pkfType.getName())) {
				    foundMatch = true;
				} else {
				    foundMatch = false;
				}
      
				if (foundMatch) {
				    result.addGoodDetails(smh.getLocalString
							  ("tests.componentNameConstructor",
							   "For [ {0} ]",
							   new Object[] {compName.toString()}));
				    result.passed(smh.getLocalString
						  (getClass().getName() + ".passed",
						   "The type of the primkey-field [ {0} ] is the same as the primary key type [ {1} ] for bean [ {2} ]",
						   new Object[] {((EjbCMPEntityDescriptor)descriptor).getPrimaryKeyFieldDesc().getName(),primkey,descriptor.getName()}));
				} else {
				    result.addErrorDetails(smh.getLocalString
							   ("tests.componentNameConstructor",
							    "For [ {0} ]",
							    new Object[] {compName.toString()}));
				    result.failed(smh.getLocalString
						  (getClass().getName() + ".failed",
						   "The type of the primkey-field [ {0} ] is not the same as the primary key type [ {1} ] for bean [ {2} ]",
						   new Object[] {((EjbCMPEntityDescriptor)descriptor).getPrimaryKeyFieldDesc().getName(),primkey,descriptor.getName()}));
				}
			    } catch (NullPointerException e) {
				result.addNaDetails(smh.getLocalString
						    ("tests.componentNameConstructor",
						     "For [ {0} ]",
						     new Object[] {compName.toString()}));
				result.notApplicable(smh.getLocalString
						     (getClass().getName() + ".notApplicable2",
						      "Primkey field not defined for [ {0} ] bean.",
						      new Object[] {descriptor.getName()}));
			    }
			} else {
			    result.addNaDetails(smh.getLocalString
						("tests.componentNameConstructor",
						 "For [ {0} ]",
						 new Object[] {compName.toString()}));
			    result.notApplicable(smh.getLocalString
						 (getClass().getName() + ".notApplicable2",
						  "Primkey field not defined for [ {0} ] bean.",
						  new Object[] {descriptor.getName()}));
			}
		    } catch (NullPointerException e) {
			result.addNaDetails(smh.getLocalString
					    ("tests.componentNameConstructor",
					     "For [ {0} ]",
					     new Object[] {compName.toString()}));
			result.notApplicable(smh.getLocalString
					     (getClass().getName() + ".notApplicable3",
					      "Primkey field not defined within [ {0} ] bean.",
					      new Object[] {descriptor.getName()}));
		    } catch (NoSuchFieldException e) {
			result.addNaDetails(smh.getLocalString
					    ("tests.componentNameConstructor",
					     "For [ {0} ]",
					     new Object[] {compName.toString()}));
			result.notApplicable(smh.getLocalString
					     (getClass().getName() + ".notApplicable2",
					      "Primkey field [ {0} ] not defined within [ {1} ] bean.",
					      new Object[] {((EjbCMPEntityDescriptor)descriptor).getPrimaryKeyFieldDesc().getName(),descriptor.getName()}));
		    }
		} catch (ClassNotFoundException e) {
		    Verifier.debug(e);
		    result.addErrorDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));
		    result.failed(smh.getLocalString
				  (getClass().getName() + ".failedException",
				   "Error: EJB class [ {0} ] does not exist or is not loadable within bean [ {1} ]",
				   new Object[] {descriptor.getEjbClassName(),descriptor.getName()}));
		}
	    } else {
		result.addNaDetails(smh.getLocalString
				    ("tests.componentNameConstructor",
				     "For [ {0} ]",
				     new Object[] {compName.toString()}));
		result.notApplicable(smh.getLocalString
				     (getClass().getName() + ".notApplicable1",
				      "Expected persistence type [ {0} ], but bean [ {1} ] has persistence type [ {2} ]",
				      new Object[] {EjbEntityDescriptor.CONTAINER_PERSISTENCE,descriptor.getName(),persistence}));
	    }
	} else {
	    result.addNaDetails(smh.getLocalString
				("tests.componentNameConstructor",
				 "For [ {0} ]",
				 new Object[] {compName.toString()}));
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "{0} expected \n {1} bean, but called with {2} bean",
				  new Object[] {getClass(),"Entity","Session"}));
	}

	return result;
    }
}
