/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.messagebean;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.MethodUtils;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/**
 * Message listener methods must not be declared as final or static.
 * 
 * @author Vikas Awasthi
 */
public class MessageListenerMethodModifiers extends MessageBeanTest {

    public Result check(EjbMessageBeanDescriptor descriptor) {
        Result result = getInitializedResult();
        ComponentNameConstructor compName = 
                            getVerifierContext().getComponentNameConstructor();

        ClassLoader cl = getVerifierContext().getClassLoader();
        try {
            Class intfCls = Class.forName(descriptor.getMessageListenerType(), false, cl);
            Class ejbCls = Class.forName(descriptor.getEjbClassName(), false, cl);
            Method[] intfMethods = intfCls.getMethods();
            for (Method method : intfMethods) {
                for (Method ejbMethod : ejbCls.getMethods()) {
                    // if matching method is found then check the assertion
                    if (MethodUtils.methodEquals(ejbMethod, method)) {
                        if(Modifier.isFinal(ejbMethod.getModifiers()) ||
                                Modifier.isStatic(ejbMethod.getModifiers())) {
                            addErrorDetails(result, compName);
                            result.failed(smh.getLocalString
                                    (getClass().getName() + ".failed",
                                            "Wrong method [ {0} ]",
                                            new Object[]{ejbMethod}));
                        }
                        break;
                    }
                }// another test will report failure if listener method is not found
            }
        } catch (ClassNotFoundException e) {} // will be caught in other tests

        if(result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                            (getClass().getName() + ".passed",
                            "Valid message listener method(s)."));
        }
        return result;
    }
}
