/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.ejb.runtime.beanpool;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;

/** ejb [0,n]
 *    bean-pool ?
 *        steady-pool-size ? [String]
 *        resize-quantity ? [String]
 *        max-pool-size ? [String]
 *        pool-idle-timeout-in-seconds ? [String]
 *        max-wait-time-in-millis ? [String]
 *
 * The resize-quantity specifies the number of beans to be created if the
 * pool is empty
 *
 * valid values are o tp MAX_INT
 *
 *
 * @author Irfan Ahmed
 */
public class ASEjbBPPoolResizeQty extends ASEjbBeanPool
{

    public Result check(EjbDescriptor descriptor)
    {
        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        String pool = null;
        String poolResizeQty = null;
        String maxPoolSize = null;
        boolean oneFailed = false;

        try{
            pool = getXPathValue("/sun-ejb-jar/enterprise-beans/ejb[ejb-name=\""+descriptor.getName()+"\"]/bean-pool");
            if (pool!=null)
            {
                poolResizeQty = getXPathValue("/sun-ejb-jar/enterprise-beans/ejb[ejb-name=\""+descriptor.getName()+"\"]/bean-pool/resize-quantity");
                try{
                    if (poolResizeQty!=null)
                    {
                        poolResizeQty = poolResizeQty.trim();
                        if (poolResizeQty.length()==0)
                        {
                            addErrorDetails(result, compName);
                            result.failed(smh.getLocalString(getClass().getName()+".failed",
                                "FAILED [AS-EJB bean-pool] : resize-quantity cannot be empty"));
                        }else
                        {
                            int resizeQtyVal = Integer.valueOf(poolResizeQty).intValue();
                            if (resizeQtyVal < 0  || resizeQtyVal > Integer.MAX_VALUE)
                            {
                                addErrorDetails(result, compName);
                                result.failed(smh.getLocalString(getClass().getName()+".failed1",
                                        "FAILED [AS-EJB bean-pool] : resize-quantity cannot be [ {0} ]. It should be between 0 and {1}",
                                        new Object[]{new Integer(poolResizeQty),new Integer(Integer.MAX_VALUE)}));
                            }else
                            {
                                int poolSizeVal=0;
                                maxPoolSize = getXPathValue("/sun-ejb-jar/enterprise-beans/ejb[ejb-name=\""+descriptor.getName()+"\"]/bean-pool/max-pool-size");
                                if (maxPoolSize!=null)
                                {
                                    try{
                                        poolSizeVal = Integer.valueOf(maxPoolSize).intValue();
                                    }catch(NumberFormatException nfe){
                                        oneFailed = true;
                                        addErrorDetails(result, compName);
                                        result.failed(smh.getLocalString(getClass().getName()+".failed2",
                                            "FAILED [AS-EJB bean-pool] : The value [ {0} ] for max-pool-size is not a valid Integer number",new Object[]{maxPoolSize}));

                                    }
                                    if (!oneFailed){
                                        if (resizeQtyVal <= poolSizeVal)
                                        {
                                            addGoodDetails(result, compName);
                                            result.passed(smh.getLocalString(getClass().getName()+".passed",
                                                "PASSED [AS-EJB bean-pool] : resize-quantity is [ {0} ] and is less-than/equal to max-pool-size[{1}]",
                                                new Object[]{new Integer(poolResizeQty), new Integer(maxPoolSize)}));
                                        }
                                        else
                                        {
                                            addWarningDetails(result, compName);
                                            result.warning(smh.getLocalString(getClass().getName()+".warning",
                                                "WARNING [AS-EJB bean-pool] : resize-quantity [ {0} ] is greater than max-pool-size [{1}]",new Object[]{new Integer(poolResizeQty), new Integer(maxPoolSize)}));
                                        }
                                    }
                                }else
                                {
                                    addGoodDetails(result, compName);
                                    result.passed(smh.getLocalString(getClass().getName()+".passed1",
                                            "PASSED [AS-EJB bean-pool] : resize-quantity is [ {0} ]", new Object[]{new Integer(poolResizeQty)}));
                                }
                            }
                        }
                    }else // if resize-quantity not defined
                    {
                        addNaDetails(result, compName);
                        result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable",
                                "NOT APPLICABLE [AS-EJB bean-pool] : resize-quantity element not defined"));
                    }
                }catch(NumberFormatException nfex){
                    Verifier.debug(nfex);
                    addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(getClass().getName()+".failed3",
                            "FAILED [AS-EJB bean-pool] : The value [ {0} ] for resize-quantity is not a valid Integer number",
                            new Object[]{poolResizeQty}));
                }
            }else // if bean-pool is not defined
            {
                addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable1",
                        "NOT APPLICABLE [AS-EJB] : bean-pool element not defined"));
            }
        }catch(Exception ex)
        {
            addErrorDetails(result, compName);
            result.addErrorDetails(smh.getLocalString
                 (getClass().getName() + ".notRun",
                  "NOT RUN [AS-EJB] : Could not create the descriptor object"));
        }
        return result;
    }
}
