package com.sun.enterprise.tools.verifier.tests.ejb.runtime.beanpool;


/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.runtime.BeanPoolDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;




/** ejb [0,n]
 *    bean-pool ?
 *        steady-pool-size ? [String]
 *        pool-resize-quantity ? [String]
 *        max-pool-size ? [String]
 *        pool-idle-timeout-in-seconds ? [String]
 *        max-wait-time-in-millis ? [String]
 *
 * The bean-pool element specifies the bean pool properties for the beans
 *
 * The bean-pool is valid only for Stateless Session Beans (SSB) and
 * Message-Driven Beans (MDB).
 * @author Irfan Ahmed
 */

public class ASEjbBeanPool extends EjbTest implements EjbCheck {

    
    public BeanPoolDescriptor beanPool;
    public Result check(EjbDescriptor descriptor)
    {
        Result result = getInitializedResult();
    	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        
        IASEjbExtraDescriptors ejbJar = descriptor.getIASEjbExtraDescriptors();
        if(ejbJar!=null)
        {
            try
            {
                beanPool = ejbJar.getBeanPool();
                if(beanPool!=null)
                {
                    if(descriptor instanceof EjbSessionDescriptor && ((EjbSessionDescriptor)descriptor).getSessionType().equals(EjbSessionDescriptor.STATEFUL))
                    {
                        result.addWarningDetails(smh.getLocalString
                                      ("tests.componentNameConstructor",
                                       "For [ {0} ]",
                                       new Object[] {compName.toString()}));
                        result.warning(smh.getLocalString(getClass().getName()+".warning",
                            "WARNING [AS-EJB ejb] : bean-pool should be defined for Stateless Session Beans, Entity Beans or Message Driven Beans"));
                    }else if(descriptor instanceof EjbMessageBeanDescriptor || (descriptor instanceof EjbSessionDescriptor && ((EjbSessionDescriptor)descriptor).getSessionType().equals(EjbSessionDescriptor.STATELESS)) || descriptor instanceof EjbEntityDescriptor){
                        result.addGoodDetails(smh.getLocalString
                                      ("tests.componentNameConstructor",
                                       "For [ {0} ]",
                                       new Object[] {compName.toString()}));
                        result.passed(smh.getLocalString(getClass().getName()+".passed",
                            "PASSED [AS-EJB ejb] : bean-pool is correctly defined"));                
                    
                    }
                }
                else
                {
                    result.addNaDetails(smh.getLocalString
                                  ("tests.componentNameConstructor",
                                   "For [ {0} ]",
                                   new Object[] {compName.toString()}));
                    result.notApplicable(smh.getLocalString(getClass().getName()+".notApplicable",
                        "NOT APPLICABLE [AS-EJB ejb] : bean-pool element not defined"));
                }
                    return result;
            }catch(Exception ex)
            {
                result.addErrorDetails(smh.getLocalString
                                       ("tests.componentNameConstructor",
                                        "For [ {0} ]",
                                        new Object[] {compName.toString()}));
                result.addErrorDetails(smh.getLocalString
                        (getClass().getName() + ".notRun",
                            "NOT RUN [AS-EJB] : Could not create a beanPool object"));
            }
        }
        else
        {
            result.addErrorDetails(smh.getLocalString
                                   ("tests.componentNameConstructor",
                                    "For [ {0} ]",
                                    new Object[] {compName.toString()}));
            result.addErrorDetails(smh.getLocalString
                 (getClass().getName() + ".notRun",
                  "NOT RUN [AS-EJB] : Could not create an IASEjbExtraDescriptor object"));
        }
        return result;
    }    
}
        
