/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.logging.Level;

import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;

/**
 * Optionally implements the enterprise Bean's remote interface test.  
 * The class may, but is not required to, implement the enterprise Bean's 
 * remote interface.  It is recommended that the enterprise bean class 
 * not implement the remote interface to prevent inadvertent passing of 
 * this as a method argument or result. 
 * Note: Display warning to user in this instance. 
 */
public class EjbClassImplementsComponentInterface extends EjbTest implements EjbCheck { 
    Result result = null;
    ComponentNameConstructor compName = null;
    /**
     * Optionally implements the enterprise Bean's remote interface test.  
     * The class may, but is not required to, implement the enterprise Bean's 
     * remote interface.  It is recommended that the enterprise bean class 
     * not implement the remote interface to prevent inadvertent passing of 
     * this as a method argument or result. 
     * Note: Display warning to user in this instance. 
     *   
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {
        result = getInitializedResult();
        compName = getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor) {
            if(descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName()))
                commonToBothInterfaces(descriptor.getRemoteClassName(),(EjbSessionDescriptor)descriptor);
            if(descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName()))
                commonToBothInterfaces(descriptor.getLocalClassName(),(EjbSessionDescriptor)descriptor);
        }
        if(result.getStatus()!=Result.FAILED && result.getStatus()!=Result.WARNING) {
            addGoodDetails(result, compName);
            result.addGoodDetails(smh.getLocalString
                            (getClass().getName() + ".passed",
                            "Bean class does not implement the enterprise Bean's remote interface"));
        }
        return result;
    }

    private void commonToBothInterfaces(String component, EjbSessionDescriptor descriptor) {
        try {
            Class c = Class.forName(descriptor.getEjbClassName(), false, getVerifierContext().getClassLoader());
            Class rc = Class.forName(component, false, getVerifierContext().getClassLoader());
            // walk up the class tree
            do {
                for (Class interfaces : c.getInterfaces()) {
                    logger.log(Level.FINE, getClass().getName() + ".debug1",
                            new Object[] {interfaces.getName()});
                    if (interfaces.getName().equals(rc.getName())) {
                        // display warning to user
                        addWarningDetails(result, compName);
                        result.warning(smh.getLocalString
                                (getClass().getName() + ".warning",
                                 "Warning: [ {0} ] class implments the " +
                                "enterprise Bean's remote interface [ {1} ].  " +
                                "It is recommended that the enterprise bean class not" +
                                " implement the remote interface to prevent " +
                                "inadvertent passing of this as a method argument or result. ",
                                 new Object[] {descriptor.getEjbClassName(),rc.getName()}));
                        break;
                    }
                }
            } while ((c=c.getSuperclass()) != null);
        } catch (ClassNotFoundException e) {
            Verifier.debug(e);
            addErrorDetails(result, compName);
            result.failed(smh.getLocalString
                        (getClass().getName() + ".failedException",
                                "Error: [ {0} ] class not found.",
                                new Object[] {descriptor.getEjbClassName()}));
        }
    }
}
