/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.*;
import java.io.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.util.FileClassLoader;


/** 
 * The session-timeout element deinfes the default session timeout interval 
 * for all sessions created in this web application.  The units used must
 * be expressed in whole minutes.
 */
public class SessionTimeout extends WebTest implements WebCheck { 

    
    /** 
     * The session-timeout element deinfes the default session timeout interval 
     * for all sessions created in this web application.  The units used must
     * be expressed in whole minutes.
     * 
     * @param descriptor the Web deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(WebBundleDescriptor descriptor) {

	Result result = getInitializedResult();
ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	boolean na = false;
	boolean foundIt = false;
	Integer sessionTimeout = new Integer(descriptor.getSessionTimeout());
	// tomcat doesn't throw exception to DOL if you pass "ten" to xml element,
	// it initializes session-timeout to -1, hence this check
	if (sessionTimeout.intValue() == -1 ) {
	    na = true;
	} else if (sessionTimeout.intValue() >= 0 ) {
	    foundIt = true;
	} else {
	    foundIt = false;
	}
   
	// always true until DOL lets something other than integer thru...
	if (na) {
	    result.addNaDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
	    result.notApplicable(smh.getLocalString
			  (getClass().getName() + ".notApplicable",
			   "Not Applicable: Servlet session-timeout [ {0} ] element does not define the default session timeout interval.",
			   new Object[] {sessionTimeout.toString()}));
	} else if (foundIt) {
	    result.addGoodDetails(smh.getLocalString
				  ("tests.componentNameConstructor",
				   "For [ {0} ]",
				   new Object[] {compName.toString()}));	
	    result.passed(smh.getLocalString
			      (getClass().getName() + ".passed",
			   "Servlet session-timeout [ {0} ] element defines the default session timeout interval expressed in whole minutes.",
			   new Object[] {sessionTimeout.toString()}));
	} else {
	    result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
	    result.failed(smh.getLocalString
			  (getClass().getName() + ".failed",
			   "Error: Servlet session-timeout [ {0} ] element does not define the default session timeout interval expressed in whole minutes.",
			   new Object[] {sessionTimeout.toString()}));
	}
	return result;
    }
}
