/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

/** 
 * The content of the url-pattern element follows the rules specified in 
 * section 10 of the servlet spec.
 * In this test we check for warnings. See bug#4880426 for more details about the motivation.
 */
public class URLPatternWarningCheck extends URLPattern { 

    protected void checkUrlPatternAndSetResult(String urlPattern, Descriptor descriptor, Result result, ComponentNameConstructor compName){

     if(urlPattern==null) return;//URLPattern1 will take care of this condition. So don't do any thing. More over, the super class would have set NA status, so we don't do that either.

     int count = new StringTokenizer(urlPattern,"*", true).countTokens();
     // See bug#4880426
     if((count ==2 && !urlPattern.endsWith("/*") && !urlPattern.startsWith("*.")) // patterns like /abc*, but not /abc/*, /*, *.jsp or *.
         || (count > 2)) //patterns like *.*, *.j*p, /*.jsp, /**, but not *.jsp
     { 
	oneWarning=true;
        result.warning(smh.getLocalString
                                 ("tests.componentNameConstructor",
                                  "For [ {0} ]",
                                  new Object[] {compName.toString()}));
        result.addWarningDetails (smh.getLocalString
                                   (getClass().getName() + ".warning",
                                    "url-pattern [ {0} ] within [ {1} ] will be used for exact match only, although it contains a *",
                                    new Object[] {urlPattern, descriptor.getName()}));
     } else {
        result.passed(smh.getLocalString
                              ("tests.componentNameConstructor",
    	                       "For [ {0} ]",
    	                       new Object[] {compName.toString()}));
    	result.addGoodDetails (smh.getLocalString
    		                (getClass().getName() + ".passed",
    		                 "url-pattern [ {0} ] within [ {1} ] follows the rules specified in servlet spec",
    		                 new Object[] {urlPattern, descriptor.getName()}));
     } 
    }
}
