/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer;

import java.io.InputStream;
import java.io.OutputStream;

import com.sun.jdo.api.persistence.enhancer.util.Support;


//@lars: changes to reflect to new ByteCodeEnhancer interface


//@olsen: new class
public final class ByteCodeEnhancerTimer
    extends Support
    implements ByteCodeEnhancer
{
    // delegate
    final protected ByteCodeEnhancer delegate;

    /**
     * Creates an instance.
     */
    public ByteCodeEnhancerTimer(ByteCodeEnhancer delegate)
    {
        affirm(delegate);
        this.delegate = delegate;
    }

    public boolean enhanceClassFile(InputStream inByteCode,
                                    OutputStream outByteCode)
        throws EnhancerUserException, EnhancerFatalError
    {
        try {
            timer.push("ByteCodeEnhancer.enhanceClassFile(InputStream,OutputStream)");//NOI18N
            return delegate.enhanceClassFile(inByteCode, outByteCode);
        } finally {
            timer.pop();
        }
    }

    public boolean enhanceClassFile(InputStream         inByteCode,
                                    OutputStreamWrapper outByteCode)
        throws EnhancerUserException, EnhancerFatalError
    {
        try {
            timer.push("ByteCodeEnhancer.enhanceClassFile(InputStream,OutputStreamWrapper)");//NOI18N
            return delegate.enhanceClassFile(inByteCode, outByteCode);
        } finally {
            timer.pop();
        }
    }
}
