/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;

import java.io.*;

/**
 * Class representing a float constant in the constant pool of a class file
 */

public class ConstFloat extends ConstValue {
  /* The tag value associated with ConstFloat */
  public static final int MyTag = CONSTANTFloat;

  /* The value */
  private float floatValue;

  /* public accessors */

  /**
   * The tag of this constant entry
   */
  public int tag () { return MyTag; }

  /**
   * return the value associated with the entry
   */
  public float value() {
    return floatValue;
  }

  /**
   * Return the descriptor string for the constant type.
   */
  public String descriptor() {
      return "F";//NOI18N
  }

  /**
   * A printable representation
   */
  public String toString () {
      return "CONSTANTFloat(" + indexAsString() + "): " + //NOI18N
          "floatValue(" + Float.toString(floatValue) + ")";//NOI18N
  }

  /* package local methods */

  ConstFloat (float f) {
    floatValue = f;
  }

  void formatData (DataOutputStream b) throws IOException {
    b.writeFloat(floatValue);
  }

  static ConstFloat read (DataInputStream input) throws IOException {
    return new ConstFloat (input.readFloat());
  }

  void resolve (ConstantPool p) { }

}


