/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;

import java.io.*;

/**
 * Class representing a reference to an interface method of some class
 * in the constant pool of a class file.
 */

public class ConstInterfaceMethodRef extends ConstBasicMemberRef {
  /* The tag value associated with ConstDouble */
  public static final int MyTag = CONSTANTInterfaceMethodRef;

  /* public accessors */

  /**
   * The tag of this constant entry
   */
  public int tag () { return MyTag; }

  /**
   * A printable representation
   */
  public String toString () {
      return "CONSTANTInterfaceMethodRef(" + indexAsString() + "): " + //NOI18N
           super.toString();
  }

  /* package local methods */

  ConstInterfaceMethodRef (ConstClass cname, ConstNameAndType NT) {
    super(cname, NT);
  }

  ConstInterfaceMethodRef (int cnameIndex, int NT_index) {
    super(cnameIndex, NT_index);
  }

  static ConstInterfaceMethodRef read (DataInputStream input) 
    throws IOException {
    int cname = input.readUnsignedShort();
    int NT = input.readUnsignedShort();
    return new ConstInterfaceMethodRef (cname, NT);
  }
}

