/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;

import java.io.*;

/**
 * Class representing a name and an associated type in the constant pool
 * of a class file
 */

public class ConstNameAndType extends ConstBasic {
  /* The tag value associated with ConstDouble */
  public static final int MyTag = CONSTANTNameAndType;

  /* The name of interest */
  private ConstUtf8 theName;

  /* The index of the name to be resolved
   *   - used during class file reading */
  private int theNameIndex;

  /* The type signature associated with the name */
  private ConstUtf8 typeSignature;

  /* The index of the signature to be resolved
   *   - used during class file reading */
  private int typeSignatureIndex;

  /* public accessors */

  /**
   * The tag of this constant entry
   */
  public int tag () { return MyTag; }

  /**
   * Return the name
   */
  public ConstUtf8 name() {
    return theName;
  }

  /**
   * Return the type signature associated with the name
   */
  public ConstUtf8 signature() {
    return typeSignature;
  }

  /**
   * Modify the signature
   */
  public void changeSignature(ConstUtf8 newSig) {
    typeSignature = newSig;
  }

  /**
   * A printable representation
   */
  public String toString () {
      return "CONSTANTNameAndType(" + indexAsString() + "): " + //NOI18N
          "name(" + theName.toString() + ") " +//NOI18N
          " type(" + typeSignature.toString() + ")";//NOI18N
  }

  /* package local methods */

  ConstNameAndType (ConstUtf8 n, ConstUtf8 sig) {
    theName = n; typeSignature = sig;
  }

  ConstNameAndType (int n, int sig) {
    theNameIndex = n; typeSignatureIndex = sig;
  }

  void formatData (DataOutputStream b) throws IOException {
    b.writeShort(theName.getIndex());
    b.writeShort(typeSignature.getIndex());
  }

  static ConstNameAndType read (DataInputStream input) throws IOException {
    int cname = input.readUnsignedShort();
    int sig = input.readUnsignedShort();

    return new ConstNameAndType (cname, sig);
  }

  void resolve (ConstantPool p) {
    theName = (ConstUtf8) p.constantAt(theNameIndex);
    typeSignature = (ConstUtf8) p.constantAt(typeSignatureIndex);
  }
}


