/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;

import java.io.*;

/**
 * LineNumberTableAttribute represents a line number table attribute
 * within a CodeAttribute within a class file
 */

public class LineNumberTableAttribute extends ClassAttribute {
  /* The expected attribute name */
    public final static String expectedAttrName = "LineNumberTable";//NOI18N

  /* The line numbers */
  private short lineNumbers[];

  /* The corresponding instructions */
  private InsnTarget targets[];

  /* public accessors */

  /**
   * Constructor
   */
  public LineNumberTableAttribute(
	ConstUtf8 nameAttr, short lineNums[], InsnTarget targets[]) {
    super(nameAttr);
    lineNumbers = lineNums;
    this.targets = targets;
  }

  /* package local methods */

  static LineNumberTableAttribute read(
	ConstUtf8 attrName, DataInputStream data, CodeEnv env)
    throws IOException {
    int nLnums = data.readUnsignedShort();
    short lineNums[] = new short[nLnums];
    InsnTarget targs[] = new InsnTarget[nLnums];
    for (int i=0; i<nLnums; i++) {
      targs[i] = env.getTarget(data.readShort());
      lineNums[i] = data.readShort();
    }
    return  new LineNumberTableAttribute(attrName, lineNums, targs);
  }

  void write(DataOutputStream out) throws IOException {
    out.writeShort(attrName().getIndex());
    int nlines = lineNumbers.length;
    out.writeInt(2+4*nlines);
    out.writeShort(nlines);
    for (int i=0; i<nlines; i++) {
      out.writeShort(targets[i].offset());
      out.writeShort(lineNumbers[i]);
    }
  }

  void print(PrintStream out, int indent) {
    ClassPrint.spaces(out, indent);
    out.println("Line Numbers: ");//NOI18N
    for (int i=0; i<lineNumbers.length; i++) {
      ClassPrint.spaces(out, indent+2);
      out.println(Integer.toString(lineNumbers[i]) + " @ " +//NOI18N
                 Integer.toString(targets[i].offset()));
    }
  }
}

