/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.util;


/**
 * Thrown to indicate that the class-file enhancer failed to perform an
 * operation due to a serious error.
 */
public class UserException
    extends RuntimeException
{
    /**
     * An optional nested exception.
     */
    public final Throwable nested;

    /**
     * Constructs an <code>UserException</code> with no detail message.
     */
    public UserException()
    {
        this.nested = null;
    }

    /**
     * Constructs an <code>UserException</code> with the specified
     * detail message.
     */
    public UserException(String msg)
    {
        super(msg);
        this.nested = null;
    }

    /**
     * Constructs an <code>UserException</code> with an optional
     * nested exception.
     */
    public UserException(Throwable nested)
    {
        super(nested.toString());
        this.nested = nested;
    }

    /**
     * Constructs an <code>UserException</code> with the specified
     * detail message and an optional nested exception.
     */
    public UserException(String msg, Throwable nested)
    {
        super(msg);
        this.nested = nested;
    }
}
