/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * JDOObjectNotFoundException.java
 *
 * Created on May 06, 2002
 */

package com.sun.jdo.api.persistence.support;

/** 
 * JDOObjectNotFoundException is thrown instead of a more generic JDODataStoreException
 * in case an internal or an external query returned 0 rows.
 *
 * @author  Marina Vatkina
 * @version 0.1
 */
public class JDOObjectNotFoundException extends JDODataStoreException {

  /**
   * Creates a new <code>JDOObjectNotFoundException</code> without detail message.
   */
  public JDOObjectNotFoundException() {
  }
  

  /**
   * Constructs a new <code>JDOObjectNotFoundException</code> with the specified 
   * detail message.
   * @param msg the detail message.
   */
  public JDOObjectNotFoundException(String msg) {
    super(msg);
  }

  /**
   * Constructs a new <code>JDOObjectNotFoundException</code> with the specified 
   * detail message and nested Exception.
   * @param msg the detail message.
   * @param nested the nested <code>Exception</code>.
   */
  public JDOObjectNotFoundException(String msg, Exception nested) {
    super(msg, nested);
  }
  
  /** Constructs a new <code>JDOObjectNotFoundException</code> with the specified 
   * detail message and failed object array.
   * @param msg the detail message.
   * @param failed the failed object array.
   */
  public JDOObjectNotFoundException(String msg, Object[] failed) {
    super(msg, failed);
  }
  
  /** Constructs a new <code>JDOObjectNotFoundException</code> with the specified 
   * detail message, nested exception, and failed object array.
   * @param msg the detail message.
   * @param nested the nested <code>Exception</code>.
   * @param failed the failed object array.
   */
  public JDOObjectNotFoundException(String msg, Exception nested, Object[] failed) {
    super(msg, nested, failed);
  }
}

