/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * PersistenceStore.java
 *
 * Created on March 3, 2000
 *
 */

package com.sun.jdo.spi.persistence.support.sqlstore;


import java.util.Collection;

/**
 * <P>This interface represents a Persistence store
 * that knows how to create, find, modify and delete persistence
 * capable objects from a backing store such as a database.
 */
public interface PersistenceStore {

    /**
     */
    public void execute(PersistenceManager pm, Collection actions);

    /**
     */
    public void executeBatch(PersistenceManager pm, UpdateObjectDesc request, boolean forceFlush);

    /**
     */
    public Object retrieve(PersistenceManager pm,
                               RetrieveDesc action,
                               ValueFetcher parameters);

    /**
     */
    public Class getClassByOidClass(Class oidType);

    /**
     */
    public StateManager getStateManager(Class classType);

    /**
     * Returns a new retrieve descriptor for an external (user) query.
     *
     * @param classType Type of the persistence capable class to be queried.
     * @return A new retrieve descriptor for an external (user) query.
     */
    public RetrieveDesc getRetrieveDesc(Class classType);

    /**
     * Returns a new retrieve descriptor for an external (user) query.
     * This retrieve descriptor can be used to query for the foreign
     * field <code>name</code>.
     *
     * @param fieldName Name of the foreign field to be queried.
     * @param classType Persistence capable class including <code>fieldName</code>.
     * @return A new retrieve descriptor for an external (user) query.
     */
    public RetrieveDesc getRetrieveDesc(String fieldName, Class classType);

    /**
     */
    public UpdateObjectDesc getUpdateObjectDesc(Class classType);


    /**
     */
    public PersistenceConfig getPersistenceConfig(
            Class classType);

    /**
     * Returns ConfigCache associated with this store.
     *
     * @return ConfigCache associated with this store.
     */
    public ConfigCache getConfigCache();
}
