/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * KeyDesc.java
 *
 * Created on March 3, 2000
 *
 */

package com.sun.jdo.spi.persistence.support.sqlstore.model;

import org.netbeans.modules.dbschema.ColumnElement;
import java.util.ArrayList;

/**
 * This class is used to encapsulate an association between
 * key fields and key columns.
 */
public class KeyDesc {

    /** Array of LocalFieldDesc */
    private ArrayList fields;

    /** Array of ColumnElements */
    private ArrayList columns;

    /** Initialize the columns ArrayList. */
    void addColumns(ArrayList columns) {
        this.columns = columns;
    }

    /** Add a field to the KeyDesc.
     *  @param f - FieldDesc to be added
     */
    void addField(FieldDesc f) {
        if (fields == null)
            fields = new ArrayList();

        fields.add(f);
    }

    /** Add a column to this KeyDesc.
     *  @param c - ColumnElement to be added
     */
    void addColumn(ColumnElement c) {
        if (columns == null)
            columns = new ArrayList();

        columns.add(c);
    }

    /** Return all key columns.
     *  @return an ArrayList of ColumnElements
     */
    public ArrayList getColumns() {
        return columns;
    }

    /** Return all key fields.
     *  @return an ArrayList of FieldDescs
     */
    public ArrayList getFields() {
        return fields;
    }
}




