/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ErrorMsg.java
 *
 * Created on April 3, 2000
 */

package com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc;

import java.util.ResourceBundle;

import com.sun.jdo.api.persistence.support.JDOQueryException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;

/** 
 *
 * @author  Michael Bouschen
 * @version 0.1
 */
public class ErrorMsg
{
    /**
     *
     */
    protected String context = null;
    
    /**
     * I18N support
     */
	protected final static ResourceBundle messages = 
      I18NHelper.loadBundle(ErrorMsg.class);

    /** The logger */
    private static Logger logger = LogHelperQueryCompilerJDO.getLogger();
    
    /**
     *
     */
    public String getContext()
    {
        return context;
    }
    
    /**
     *
     */
    public void setContext(String name)
    {
        context = name;
    }

    /**
	 * Indicates an error situation. 
     * @param line line number
     * @param col column number
     * @param msg error message
	 */
    public void error(int line, int col, String msg)
        throws JDOQueryException
	{
        JDOQueryException ex;
        if (line > 1)
        {
            // include line and column info
            Object args[] = {context, new Integer(line), new Integer(col), msg};
            ex = new JDOQueryException(I18NHelper.getMessage(
                messages, "jqlc.errormsg.generic.msglinecolumn", args)); //NOI18N
        }
        else if (col > 0)
        {
            // include column info
            Object args[] = {context, new Integer(col), msg};
            ex = new JDOQueryException(I18NHelper.getMessage(
                messages, "jqlc.errormsg.generic.msgcolumn", args)); //NOI18N
        }
        else 
        {
            Object args[] = {context, msg};
            ex = new JDOQueryException(I18NHelper.getMessage(
                messages, "jqlc.errormsg.generic.msg", args)); //NOI18N
        }
        logger.throwing("jqlc.ErrorMsg", "error", ex);
        throw ex;
	}
    
    /**
	 * Indicates that a feature is not supported by the current release. 
     * @param line line number
     * @param col column number
     * @param msg message
	 */
    public void unsupported(int line, int col, String msg)
        throws JDOUnsupportedOptionException
	{
        JDOUnsupportedOptionException ex;
        if (line > 1)
        {
            // include line and column info
            Object args[] = {context, new Integer(line), new Integer(col), msg};
            ex = new JDOUnsupportedOptionException(I18NHelper.getMessage(
                messages, "jqlc.errormsg.generic.msglinecolumn", args)); //NOI18N
        }
        else if (col > 0)
        {
            // include column info
            Object args[] = {context, new Integer(col), msg};
            ex = new JDOUnsupportedOptionException(I18NHelper.getMessage(
                messages, "jqlc.errormsg.generic.msgcolumn", args)); //NOI18N
                                                                         
        }
        else 
        {
            Object args[] = {context, msg};
            ex = new JDOUnsupportedOptionException(I18NHelper.getMessage(
                messages, "jqlc.errormsg.generic.msg", args)); //NOI18N
        }	
        logger.throwing("jqlc.ErrorMsg", "unsupported", ex);
        throw ex;
    }
    
    /**
	 * Indicates a fatal situation (implementation error).
     * @param msg error message
	 */
	public void fatal(String msg)
        throws JDOFatalInternalException
	{
        JDOFatalInternalException ex = new JDOFatalInternalException(msg);
        logger.throwing("jqlc.ErrorMsg", "fatal", ex);
        throw ex;
	}

    /**
	 * Indicates a fatal situation (implementation error).
     * @param msg error message
	 */
	public void fatal(String msg, Exception nested)
        throws JDOFatalInternalException
	{
        JDOFatalInternalException ex = new JDOFatalInternalException(msg, nested);
        logger.throwing("jqlc.ErrorMsg", "fatal", ex);
        throw ex;
	}
}


