/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Definition.java
 *
 * Created on March 8, 2000
 */

package com.sun.jdo.spi.persistence.support.sqlstore.query.util.scope;

import java.util.ResourceBundle;

import com.sun.jdo.spi.persistence.utility.I18NHelper; 

import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.Type;

/**
 * Super class of all possible identifier definitions
 *
 * @author  Michael Bouschen
 * @version 0.1
 */
public abstract class Definition
{
    /**
     * I18N support
     */
	protected final static ResourceBundle messages = 
            I18NHelper.loadBundle(Definition.class);
    
    /**
     * Scope level of the definition
     */
    protected int scope;

    /**
     * Type of the identifier
     */
    protected Type type;

    /**
     * Creates a new definition.
     * A definition contains at least the type of the identifier.
     * @param type type of the declared identifier
     */
    public Definition (Type type)
    {
        this.type = type;
    }

    /**
     * Set the scope of the identifier's definition.
     */
    public void setScope(int scope)
    {
        this.scope = scope;
    }

    /**
     * Returns the scope of the identifier's definition.
     */
    public int getScope()
    {
        return scope;
    }

    /**
     * Returns the type of the identifiers's definition.
     */
    public Type getType()
    {
        return type;
    }
	
    /**
     * Returns the name of the definition.
     */
    public abstract String getName();
}
