/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ConcurrencyOptVerify.java
 *
 * Created on March 3, 2000
 *
 */

package com.sun.jdo.spi.persistence.support.sqlstore.sql.concurrency;

import com.sun.jdo.spi.persistence.support.sqlstore.model.FieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.UpdateQueryPlan;

import java.util.ArrayList;
import java.util.BitSet;

/**
 */
public class ConcurrencyOptVerify extends ConcurrencyCheckDirty {

    /**
     * Find all the local fields that have been updated
     * and use their concurrencyGroup to set the verifyGroupMask.
     */
    protected BitSet prepareVerifyGroupMask(UpdateQueryPlan plan) {
        ArrayList fields;
        BitSet verifyGroupMask = new BitSet();
        int action = plan.getAction();

        for (int i = 0; i <= 1; i++) {
            if (i == 0) {
                fields = plan.getConfig().fields;
            } else {
                fields = plan.getConfig().hiddenFields;
            }

            if (fields == null) {
                continue;
            }

            for (int j = 0; j < fields.size(); j++) {
                FieldDesc f = (FieldDesc) fields.get(j);

                if ((f instanceof LocalFieldDesc) &&
                        (f.sqlProperties & FieldDesc.PROP_IN_CONCURRENCY_CHECK) > 0) {
 
                    // In the case of a deleted instance with no modified fields
                    // we use the present fields in the before image to perform
                    // the concurrency check.
                    if (afterImage.getSetMaskBit(f.absoluteID) ||
                            ((action == QueryPlan.ACT_DELETE) &&
                            beforeImage.getPresenceMaskBit(f.absoluteID))) {
                        if (f.concurrencyGroup != -1) {
                            verifyGroupMask.set(f.concurrencyGroup);
                        }
                    }
                }
            }
        }

        return verifyGroupMask;
    }

    protected boolean isFieldVerificationRequired(LocalFieldDesc lf,
                                                  BitSet verifyGroupMask) {
        boolean fieldVerificationRequired = true;

        if (lf.concurrencyGroup == -1) {
            if (!afterImage.getSetMaskBit(lf.absoluteID)) {
                fieldVerificationRequired = false;
            }
        } else {
            if (!verifyGroupMask.get(lf.concurrencyGroup)) {
                fieldVerificationRequired = false;
            }
        }

        return fieldVerificationRequired;
    }

    public Object clone() {
        return new ConcurrencyOptVerify();
    }
}






