/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * InputParamValue.java
 *
 * Created on March 13, 2002
 * @author  Daniel Tonn
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import org.netbeans.modules.dbschema.ColumnElement;

/**
 * An extended InputValue which represents a query input parameter value.
 * This class holds the index of the parameter, which is used
 * to get the real value for binding the input parameter. 
 */
public class InputParamValue extends InputValue 
{    
    /**
     * Constructor.
     * @param index parameter index
     * @param columnElement The ColumnElment to which this parameter will be
     * bound
     */
    public InputParamValue(Integer index, ColumnElement columnElement) {
        super(index, columnElement);
    }

    public Integer getParamIndex() {
        return (Integer) getValue();
    }
}
