/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * NumericConverterFactory.java
 *
 * Created on March 21, 2003
 */

package com.sun.jdo.spi.persistence.support.sqlstore.utility;

import java.math.BigDecimal;
import java.math.BigInteger;

/**
 * This is a factory class for NumericConverter.
 *
 * @author Shing Wai Chan
 */
public class NumericConverterFactory {
     private static NumericConverter defaultConverter = new NumericConverterImpl();

     /**
      * @param policy for determining mechanism for conversion from BigDecimal
      *        to BigInteger
      */
     protected NumericConverterFactory() {
     }

     /**
      * This method returns an instance of NumericConverter for a given policy.
      * @param policy for determining mechanism for conversion from 
      *        inexact type to exact type.
      * @return NumericConverter corresponds to a policy
      */
     public static NumericConverter getNumericConverter(int policy) {
         return defaultConverter;
     }
}
