/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * TickEventListener.java
 *
 * Create on March 4, 2000
 */

package com.sun.jdo.spi.persistence.support.sqlstore.utility;
import java.util.EventListener;

/**
 * This interface defines an event listener that responds to 
 * ticks sent from 
 * a <code>Timer</code> object when its interval expires. 
 * An object that uses a timer must implement this interface, 
 * which enables the object to respond to tick events 
 * (<code>TickEvent</code> objects) from a <code>Timer</code> object.
 * <P>For information about using events, see the <I>SynerJ
 * Programming Guide.</I>
 * @see com.forte.util.Timer
 * @see com.forte.util.TickEvent
 */
public interface TickEventListener extends EventListener
{
	/**
	 * Detects each timer tick, and performs an action 
	 * appropriate to the object using the timer.
	 * This method must be implemented in the object that uses the timer. 
	 */
	public abstract void tick(TickEvent evt);
}
